% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_imdanova_melt.R
\name{pre_imdanova_melt}
\alias{pre_imdanova_melt}
\title{Create a Melted and Grouped Version of e_data for IMD_ANOVA filter}
\usage{
pre_imdanova_melt(e_data, groupDF, samp_id)
}
\arguments{
\item{e_data}{\eqn{p \times n} data.frame, where \eqn{p} is the number of
peptides, proteins, lipids, metabolites, or accessions and \eqn{n} is the
number of samples}

\item{groupDF}{data frame created by \code{group_designation} with columns
for the sample identifier and the designated group.}

\item{samp_id}{character string specifying the name of the column containing
the sample identifiers in \code{groupDF}.}
}
\value{
a data frame of class "grouped_dt" which is compatible with functions
  in the dplyr package
}
\description{
This function creates a melted version of e_data, grouped by edata_id and
group designation, for future use of implementing a IMD_ANOVA filter
}
\author{
Lisa Bramer, Kelly Stratton
}
