% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_summary.R
\name{summary.imdanovaFilt}
\alias{summary.imdanovaFilt}
\title{IMD-ANOVA Filter Summary}
\usage{
\method{summary}{imdanovaFilt}(
  object,
  min_nonmiss_anova = NULL,
  min_nonmiss_gtest = NULL,
  comparisons = NULL,
  ...
)
}
\arguments{
\item{object}{S3 object of class 'imdanovaFilt' created by
\code{\link{imdanova_filter}}.}

\item{min_nonmiss_anova}{integer value specifying the minimum number of
non-missing feature values allowed per group for \code{anova_filter}.
Defaults to NULL. Suggested value is 2.}

\item{min_nonmiss_gtest}{integer value specifying the minimum number of
non-missing feature values allowed per group for \code{gtest_filter}.
Defaults to NULL. Suggested value is 3.}

\item{comparisons}{data frame with columns for "Control" and "Test"
containing the different comparisons of interest. Comparisons will be made
between the Test and the corresponding Control (e.g. Control is the
reference group).}

\item{...}{further arguments passed to or from other methods}
}
\value{
If min_nonmiss_gtest or min_nonmiss_anova is specified, the number of
  biomolecules to be filtered with the specified threshold are reported.
}
\description{
Provide summary of a imdanovaFilt S3 object
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mypep <- group_designation(omicsData = pep_object, main_effects = "Phenotype")
myfilt <- imdanova_filter(omicsData = mypep)
summary(myfilt, min_nonmiss_anova = 2, min_nonmiss_gtest = 3)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{imdanova_filter}}
}
\author{
Lisa Bramer
}
