% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.trelliData.R
\name{trelli_panel_by}
\alias{trelli_panel_by}
\title{Set the "panel_by" variable for a trelliData object}
\usage{
trelli_panel_by(trelliData, panel)
}
\arguments{
\item{trelliData}{A trelliscope data object made by as.trelliData or as.trelliData.edata. Required.}

\item{panel}{The name of a column in trelliData to panel the data by. Required.}
}
\value{
A trelliData object with attributes "panel_by_omics" or "panel_by_stat" to determine 
which columns to divide the data by.
}
\description{
Allows for grouping omics or stats data for downstream plotting
    and cognostic functions
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(pmartRdata)

trelliData1 <- as.trelliData.edata(e_data = pep_edata,
                                   edata_cname = "Peptide",
                                   omics_type = "pepData")
# Transform the data
omicsData <- edata_transform(omicsData = pep_object, data_scale = "log2")

# Group the data by condition
omicsData <- group_designation(omicsData = omicsData, main_effects = c("Phenotype"))

# Apply the IMD ANOVA filter
imdanova_Filt <- imdanova_filter(omicsData = omicsData)
omicsData <- applyFilt(filter_object = imdanova_Filt, omicsData = omicsData,
                       min_nonmiss_anova = 2)

# Normalize my pepData
omicsData <- normalize_global(omicsData, "subset_fn" = "all", "norm_fn" = "median",
                             "apply_norm" = TRUE, "backtransform" = TRUE)

# Implement the IMD ANOVA method and compute all pairwise comparisons 
# (i.e. leave the `comparisons` argument NULL)
statRes <- imd_anova(omicsData = omicsData, test_method = 'combined')

# Generate the trelliData object
trelliData2 <- as.trelliData(omicsData = omicsData)
trelliData3 <- as.trelliData(statRes = statRes)
trelliData4 <- as.trelliData(omicsData = omicsData, statRes = statRes)

## "panel_by" with an edata file. 
trelli_panel_by(trelliData = trelliData1, panel = "Peptide")
trelli_panel_by(trelliData = trelliData1, panel = "Sample")

## "panel_by" with trelliData containing omicsData. 
## Generate trelliData2 using the example code for as.trelliData
trelli_panel_by(trelliData = trelliData2, panel = "Peptide")
trelli_panel_by(trelliData = trelliData2, panel = "RazorProtein")

## "panel_by" with trelliData containing statRes. 
## Generate trelliData3 using the example code for as.trelliData
trelli_panel_by(trelliData = trelliData3, panel = "Peptide")

## "panel_by" with trelliData containing both omicsData and statRes. 
## Generate trelliData4 using the example code for as.trelliData
trelli_panel_by(trelliData = trelliData4, panel = "Peptide")
trelli_panel_by(trelliData = trelliData4, panel = "RazorProtein")
trelli_panel_by(trelliData = trelliData4, panel = "SampleID")
}
\dontshow{\}) # examplesIf}
}
\author{
David Degnan, Lisa Bramer
}
