\name{One Step of EM algorithm}
\alias{em.onestep}
\alias{em.onestep.dmat}
\title{One EM Step for GBD}
\description{
  One EM step only for model-based clustering of finite mixture Gaussian
  models with unstructured dispersions.
  This is a core function of \code{\link{em.step}}.

  \code{em.onestep.dmat} is a \code{ddmatrix} version of \code{em.onestep}.
}
\usage{
  em.onestep(PARAM)

  em.onestep.dmat(PARAM)
}
\arguments{
  \item{PARAM}{an original set of parameters generated
                   by \code{\link{set.global}}.}
}
\details{
  A global variable called \code{\link{X.spmd}} should exist in the
  \code{\link{.pmclustEnv}}
  environment, usually the working environment. The \code{\link{X.spmd}}
  is the data matrix to be clustered, and this matrix has a dimension
  \code{N.spmd} by \code{p}.

  The \code{PARAM} will be a local variable for the current iteration inside
  \code{\link{em.onestep}},
  and this variable is a list containing all parameters related to models.
  This function also updates in the parameters by the EM algorithm, and
  return a new \code{\link{PARAM}} for the next iteration.
  The details of list elements are initially
  generated by \code{\link{set.global}}.
}
\value{
  This function is one EM step. The global variables will be updated and
  a new \code{\link{PARAM}} will be returned.
  See the help page of \code{\link{PARAM}} or \code{\link{PARAM.org}}
  for details.
}
\references{
  Programming with Big Data in R Website:
  \url{http://r-pbd.org/}
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com} and George Ostrouchov.
}
\seealso{
  \code{\link{set.global}},
  \code{\link{e.step}},
  \code{\link{m.step}}.
}
\examples{
\dontrun{
# This is a core function for em.step()
# see the source code for details.
}
}
\keyword{core function}

