% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterEstimationHelper.R
\name{pmh}
\alias{pmh}
\title{Particle Metropolis-Hastings algorithm for a linear Gaussian state space 
model}
\usage{
pmh(y, initPar, sigmav, sigmae, nPart, T, x0, nIter, stepSize)
}
\arguments{
\item{y}{Observations from the model for \eqn{t=1,...,T}.}

\item{initPar}{The mean of the log-volatility process \eqn{\mu}.}

\item{sigmav}{The standard deviation of the state process \eqn{\sigma_v}.}

\item{sigmae}{The standard deviation of the observation process 
\eqn{\sigma_e}.}

\item{nPart}{The number of particles to use in the filter.}

\item{T}{The number of observations.}

\item{x0}{The inital state.}

\item{nIter}{The number of iterations in the PMH algorithm.}

\item{stepSize}{The standard deviation of the Gaussian random walk proposal 
for \eqn{\phi}.}
}
\value{
The trace of the Markov chain exploring the marginal posterior for 
\eqn{\phi}.
}
\description{
Estimates the parameter posterior for \eqn{phi} a linear Gaussian state 
space model of the form \eqn{ x_{t} = \phi x_{t-1} + \sigma_v v_t } and 
\eqn{ y_t = x_t + \sigma_e e_t }, where \eqn{v_t} and \eqn{e_t} denote 
independent standard Gaussian random variables, i.e.\eqn{N(0,1)}.
}
\note{
See Section 4.3 in the reference for more details.
}
\examples{
\dontrun{
# Use a short run when testing the code on CRAN
# Set nIter manually if running on local computer, 
# nIter=1000 is usually enough
if(nchar(Sys.getenv("LONG_TEST")) != 0) {
  nIter=7500
} else {
  nIter=100
}
## Generates T=500 observations from a linear state space model with
## ( phi, sigma_e, sigma_v ) = ( 0.5, 1.0, 0.1 ) and zero initial state.

d <- generateData(phi=0.5, sigmav=1.0, sigmae=0.1, T=500, x0=0.0) 

## Estimate the marginal posterior for phi
res   <- pmh(d$y, initPar=0.1, sigmav=1.0, sigmae=0.1, nPart=50, T=500, 
             x0=0.0, nIter, stepSize=0.10)

## Plot the estimate
par(mfrow=c(1,1))
hist(res, main="", xlab=expression(phi), 
     ylab="marginal posterior", freq=FALSE)

}
}
\author{
Johan Dahlin <johan.dahlin@liu.se>
}
\references{
Dahlin, J. & Schoen, T. B. "Getting started with particle 
Metropolis-Hastings for inference in nonlinear dynamical models." 
pre-print, arXiv:1511.01707, 2015.
}
\keyword{ts}

