% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\title{Initialise values for the random effects}
\usage{
init(
  pmwgs,
  start_mu = NULL,
  start_sig = NULL,
  display_progress = TRUE,
  particles = 1000
)
}
\arguments{
\item{pmwgs}{The sampler object that provides the parameters.}

\item{start_mu}{An array of starting values for the group means}

\item{start_sig}{An array of starting values for the group covariance matrix}

\item{display_progress}{Display a progress bar during sampling}

\item{particles}{The number of particles to generate in initialisation}
}
\value{
The sampler object but with initial values set for \code{theta_mu},
  \code{theta_sig}, \code{alpha} and other values for the first sample.
}
\description{
Initialise the random effects for each participant using MCMC.
}
\details{
Before sampling can start the Particle Metropolis within Gibbs sampler needs
initial values for the random effects. The \code{init} function generates
these values using a Monte Carlo algorithm. One alternative methods would be
setting the initial values randomly.

Optionally takes starting values for the model parameters and the variance /
covariance matrix. All arrays must match the appropriate shape.

For example, with 5 parameters and 10 subjects, the model parameter start
means must be a vector of length 5 and the covariance matrix must be an array
of 5 x 5.

Alternatively the if argument values for the starting points are left at the
default (NULL) then starting points will be sampled from the prior for group
level values (model parameters and covariance matrix)
}
\examples{
lba_ll <- function(x, data) {
  x <- exp(x)
  if (any(data$rt < x["t0"])) {
    return(-1e10)
  }
  sum(
    log(
      rtdists::dLBA(
        rt = data$rt,
        response = data$correct,
        A = x["A"],
        b = x["A"] + x[c("b1", "b2", "b3")][data$condition],
        t0 = x["t0"],
        mean_v = x[c("v1", "v2")],
        sd_v = c(1, 1),
        silent = TRUE
      )
    )
  )
}
sampler <- pmwgs(
  forstmann,
  c("b1", "b2", "b3", "A", "v1", "v2", "t0"),
  lba_ll
)
sampler <- init(sampler, start_mu = rnorm(7), start_sig = diag(rep(0.01, 7)))
}
