% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_derived_1cpt.R
\name{calc_derived_1cpt}
\alias{calc_derived_1cpt}
\title{Calculate derived pharmacokinetic parameters for a 1-compartment linear model}
\usage{
calc_derived_1cpt(CL, V, type = "all", sigdig = 5)
}
\arguments{
\item{CL}{Clearance (L/h)}

\item{V}{Central volume of distribution (L)}

\item{type}{Type of half-life to return (\code{"Vss"}, \code{"k10"}, \code{"thalf"}, \code{"alpha"}, \code{"trueA"}, \code{"fracA"}, \code{"all"}). Default is \code{"all"}).}

\item{sigdig}{Number of significant digits to be returned. Default is 5.}
}
\value{
Return a list of derived PK parameters for a 2-compartment linear model given provided clearances and volumes.
\itemize{ 
  \item \code{Vss}: \eqn{V_{ss}} (L)
  \item \code{k10}: \eqn{k_{10}} (/h)
  \item \code{thalf}: \eqn{t_{1/2}} (h)
  \item \code{alpha}: \eqn{\alpha}
  \item \code{trueA}: true A
  \item \code{fracA}: fractional A
 }
}
\description{
Calculate derived pharmacokinetic parameters for a 1-compartment linear model
}
\examples{
params <- calc_derived_1cpt(CL=16, V=25)

}
\references{
Shafer S. L. \code{CONVERT.XLS}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
