% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emailing.R
\name{email_create}
\alias{email_create}
\title{Create an email object from a \strong{pointblank} \emph{agent}}
\usage{
email_create(
  x,
  msg_header = NULL,
  msg_body = stock_msg_body(),
  msg_footer = stock_msg_footer()
)
}
\arguments{
\item{x}{A \strong{pointblank} \emph{agent}.}

\item{msg_header, msg_body, msg_footer}{Content for the header, body, and
footer components of the HTML email message.}
}
\value{
A \strong{blastula} \code{email_message} object.
}
\description{
The \code{email_create()} function produces an email message object that could be
sent using the \strong{blastula} package. By supplying a \strong{pointblank} agent, a
\strong{blastula} \code{email_message} message object will be created and printing it
will make the HTML email message appear in the Viewer.
}
\section{Examples}{


For the example provided here, we'll use the included \code{small_table} dataset.
We are also going to create an \code{action_levels()} list object since this is
useful for demonstrating an emailing scenario. It will have absolute values
for the \code{warn} and \code{notify} states (with thresholds of \code{1} and \code{2} 'fail'
units, respectively, for the two states).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{al <- 
  action_levels(
    warn_at = 1,
    notify_at = 2
  )
}\if{html}{\out{</div>}}

In a workflow that involves an \code{agent} object, we can make use of the
\code{end_fns} argument and programmatically email the report with the
\code{\link[=email_blast]{email_blast()}} function. However, an alternate workflow that is demonstrated
here is to produce the email object directly. This provides the flexibility
to send the email outside of the \strong{pointblank} API. The \code{email_create()}
function lets us do this with an \code{agent} object. We can then view the HTML
email just by printing \code{email_object}. It should appear in the Viewer.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{email_object <-
  create_agent(
    tbl = small_table,
    tbl_name = "small_table",
    label = "An example.",
    actions = al
  ) \%>\%
  col_vals_gt(vars(a), value = 1) \%>\%
  col_vals_lt(vars(a), value = 7) \%>\%
  interrogate() \%>\%
  email_create()
  
email_object
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rich-iannone/pointblank/main/images/man_email_create_1.png" alt="This image was generated from the first code example in the `email_create()` help file." style="width:100\%;">
}
}
}

\section{Function ID}{

4-2
}

\seealso{
Other Emailing: 
\code{\link{email_blast}()},
\code{\link{stock_msg_body}()},
\code{\link{stock_msg_footer}()}
}
\concept{Emailing}
