% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_agent_report.R
\name{get_agent_report}
\alias{get_agent_report}
\title{Get a simple report from an agent}
\usage{
get_agent_report(
  agent,
  arrange_by = c("i", "severity"),
  keep = c("all", "fail_states"),
  display_table = TRUE,
  ...
)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}.}

\item{arrange_by}{A choice to arrange the report table rows by the validation
step number (\code{"i"}, the default), or, to arrange in descending order by
severity of the failure state (with \code{"severity"}).}

\item{keep}{An option to keep \code{"all"} of the report's table rows (the
default), or, keep only those rows that reflect one or more
\code{"fail_states"}.}

\item{display_table}{Should a display table be generated? If \code{TRUE} (the
default), and if the \strong{gt} package is installed, a display table for the
report will be shown in the Viewer. If \code{FALSE}, or if \strong{gt} is not
available, then a tibble will be returned.}

\item{...}{Additional options passed to downstream functions.}
}
\value{
A tibble.
}
\description{
We can get the essential information from an agent by using the
\code{get_agent_report()} function. The amount of fields with intel is different
depending on whether or not the agent performed an interrogation (with
\code{interrogate()}). The tibble that is returned has the following columns:
\itemize{
\item i: the validation step number
\item type: the validation type, which mirrors the name of the validation
step function
\item columns: the names of the columns used in the validation step
\item values: the values used in the validation step, where applicable; for
a \code{conjointly()} validation step, this is a listing of all sub-validations
\item precon: indicates whether any there are any preconditions to apply
before interrogation and, if so, the number of statements used
\item active: a logical value that indicates whether a validation step is
set to 'active' during an interrogation
\item eval: a character value that denotes the result of each validation
step functions' evaluation during interrogation
\item units: the total number of validation units for the validation step
\item n_pass: the number of validation units that received a \emph{pass}
\item f_pass: the fraction of validation units that received a \emph{pass}
\item W: a logical value stating whether the \code{warn} state was entered
\item S: a logical value stating whether the \code{stop} state was entered
\item N: a logical value stating whether the \code{notify} state was entered
\item extract: a logical value that indicates whether a data extract is
available for the validation step
}
If the \strong{gt} package is installed (and if \code{display_table = TRUE}, which is
the default) then a \strong{gt} table will be displayed with the same information.
}
\section{Function ID}{

5-1
}

\examples{
# Create a simple table with a
# column of numerical values
tbl <- 
  dplyr::tibble(a = c(5, 7, 8, 5))

# Validate that values in column
# `a` are always greater than 4
agent <-
  create_agent(tbl = tbl) \%>\%
  col_vals_gt(vars(a), 4) \%>\%
  interrogate()

# Get a tibble-based report from the
# agent by using `get_agent_report()`
agent \%>\%
  get_agent_report(display_table = FALSE)

}
\seealso{
Other Post-interrogation: 
\code{\link{all_passed}()},
\code{\link{get_agent_x_list}()},
\code{\link{get_data_extracts}()},
\code{\link{get_sundered_data}()}
}
\concept{Post-interrogation}
