% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agent_ops.R
\name{set_read_fn}
\alias{set_read_fn}
\title{Set a table-reading function to an agent}
\usage{
set_read_fn(agent, read_fn)
}
\arguments{
\item{agent}{An \emph{agent} object of class \code{ptblank_agent} that is created with
\code{\link[=create_agent]{create_agent()}}.}

\item{read_fn}{A function that's used for reading in the data. If a table is
not associated with the \code{agent} then this function will be invoked. Should
both a \code{tbl} \emph{and} a \code{read_fn} be associated with the \code{agent}, the \code{tbl}
will take priority. There are two ways to specify a \code{read_fn}: (1) using a
function (e.g., \verb{function() \{ <table reading code> \}}) or, (2) with an R
formula expression (e.g., \verb{~ \{ <table reading code> \}}).}
}
\description{
A table-reading function can be associated with an \emph{agent} with
\code{set_read_fn()}. If a data table is already associated with an \emph{agent}, it
will act as the target table (i.e., the \emph{agent} will disregard the
table-reading function). However, if there is no data table associated with
the \emph{agent} then the table-reading function will be invoked. We can always
remove a data table associated with an \emph{agent} with the \code{\link[=remove_tbl]{remove_tbl()}}
function. There are two ways to specify a \code{read_fn}: (1) using a function
(e.g., \verb{function() \{ <table reading code> \}}) or, (2) with an R formula
expression (e.g., \verb{~ \{ <table reading code> \}}).
}
