% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_tbl.R
\name{db_tbl}
\alias{db_tbl}
\title{Get a table from a database}
\usage{
db_tbl(db, dbname, table, user, password, host = NULL, port = NULL)
}
\arguments{
\item{db}{Either an appropriate driver function (e.g.,
\code{RPostgres::Postgres()}) or a shorthand name for the database type. Valid
names are: \code{"postgresql"}, \code{"postgres"}, or \code{"pgsql"} (PostgreSQL, using
the \code{RPostgres::Postgres()} driver function); \code{"mysql"} (MySQL, using
\code{RMySQL::MySQL()}); \code{"maria"} or \code{"mariadb"} (MariaDB, using
\code{RMariaDB::MariaDB()}); \code{"duckdb"} (DuckDB, using \code{duckdb::duckdb()}); and
\code{"sqlite"} (SQLite, using \code{RSQLite::SQLite()}).}

\item{dbname}{The database name.}

\item{table}{The name of the table, or, a reference to a table in a schema
(two-element vector with the names of schema and table). Alternatively,
this can be supplied as a data table to copy into an in-memory database
connection. This only works if: (1) the \code{db} is either \code{"sqlite"} or
\code{"duckdb"}, (2) the \code{dbname} was chosen as \code{":memory:"}, and (3) the
\code{data_tbl} is a data frame or a tibble object.}

\item{user, password}{The environment variables used to access the username
and password for the database.}

\item{host, port}{The database host and optional port number.}
}
\value{
A \code{tbl_dbi} object.
}
\description{
If your target table is in a database, the \code{db_tbl()} function
is a handy way of accessing it. This function simplifies the process of
getting a \code{tbl_dbi} object, which usually involves a combination of building
a connection to a database and using the \code{dplyr::tbl()} function with the
connection and the table name (or a reference to a table in a schema). A
better option is to use this function as the \code{read_fn} parameter in
\code{\link[=create_agent]{create_agent()}} and \code{\link[=create_informant]{create_informant()}}. This can be done by using a
leading \code{~} (e.g,. \code{read_fn = ~db_tbl(...)}).

The username and password are supplied though environment variables. If
desired, these can be supplied directly by enclosing those values in \code{I()}.
}
\section{Function ID}{

1-6
}

\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{col_schema}()},
\code{\link{create_agent}()},
\code{\link{create_informant}()},
\code{\link{scan_data}()},
\code{\link{validate_rmd}()}
}
\concept{Planning and Prep}
