% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_truncate}
\alias{ExprDT_truncate}
\alias{(Expr)$dt$truncate}
\title{Truncate datetime}
\format{
function
}
\arguments{
\item{every}{string encoding duration see details.}

\item{ofset}{optional string encoding duration see details.}
}
\value{
Date/Datetime expr
}
\description{
Divide the date/datetime range into buckets.
Each date/datetime is mapped to the start of its bucket.
}
\details{
The \code{every} and \code{offset} argument are created with the
the following string language:
\itemize{
\item 1ns # 1 nanosecond
\item 1us # 1 microsecond
\item 1ms # 1 millisecond
\item 1s  # 1 second
\item 1m  # 1 minute
\item 1h  # 1 hour
\item 1d  # 1 day
\item 1w  # 1 calendar week
\item 1mo # 1 calendar month
\item 1y  # 1 calendar year
These strings can be combined:
\itemize{
\item 3d12h4m25s # 3 days, 12 hours, 4 minutes, and 25 seconds
}
}
}
\examples{
t1 = as.POSIXct("3040-01-01", tz = "GMT")
t2 = t1 + as.difftime(25, units = "secs")
s = pl$date_range(t1, t2, interval = "2s", time_unit = "ms", lazy = FALSE)

# use a dt namespace function
df = pl$DataFrame(datetime = s)$with_columns(
  pl$col("datetime")$dt$truncate("4s")$alias("truncated_4s"),
  pl$col("datetime")$dt$truncate("4s", offset("3s"))$alias("truncated_4s_offset_2s")
)
df
}
\keyword{ExprDT}
