% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_tree.R
\name{predict.policy_tree}
\alias{predict.policy_tree}
\title{Predict method for policy_tree}
\usage{
\method{predict}{policy_tree}(object, newdata, ...)
}
\arguments{
\item{object}{policy_tree object}

\item{newdata}{A data frame with features}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A vector of predictions. Each element is an integer from 1 to d where d is
the number of columns in the reward matrix.
}
\description{
Predict values based on fitted policy_tree object.
}
\examples{
\donttest{
# Fit a depth two tree on doubly robust treatment effect estimates
# from a causal forest.
n <- 10000
p <- 5
X <- round(matrix(rnorm(n * p), n, p), 2)
W <- rbinom(n, 1, 1 / (1 + exp(X[, 3])))
tau <- 1 / (1 + exp((X[, 1] + X[, 2]) / 2)) - 0.5
Y <- X[, 3] + W * tau + rnorm(n)
c.forest <- grf::causal_forest(X, Y, W)
dr.scores <- double_robust_scores(c.forest)

tree <- policy_tree(X, dr.scores, 2)
tree

# Predict treatment assignment.
predicted <- predict(tree, X)

plot(X[, 1], X[, 2], col = predicted)
legend("topright", c("control", "treat"), col = c(1, 2), pch = 19)
abline(0, -1, lty = 2)
}
}
