% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policytree-package.R
\docType{package}
\name{policytree-package}
\alias{policytree}
\alias{policytree-package}
\title{policytree: Policy Learning via Doubly Robust Empirical Welfare Maximization over Trees}
\description{
A package for learning simple rule-based policies, where the rule takes the form of a shallow decision tree. Applications include settings which require interpretable predictions, such as for example a medical treatment prescription. This package uses doubly robust reward estimates from \code{grf} to find a shallow, but globally optimal decision tree.

Some helpful links for getting started:
\itemize{
\item The R package documentation contains usage examples and method references (\url{https://grf-labs.github.io/policytree/}).
\item For community questions and answers around usage, see the GitHub issues page (\url{https://github.com/grf-labs/policytree/issues}).
}
}
\examples{
\donttest{
# Multi-action policy learning example.
n <- 250
p <- 10
X <- matrix(rnorm(n * p), n, p)
W <- as.factor(sample(c("A", "B", "C"), n, replace = TRUE))
Y <- X[, 1] + X[, 2] * (W == "B") + X[, 3] * (W == "C") + runif(n)
multi.forest <- grf::multi_arm_causal_forest(X, Y, W)

# Compute doubly robust reward estimates.
Gamma.matrix <- double_robust_scores(multi.forest)

# Fit a depth 2 tree on a random training subset.
train <- sample(1:n, 200)
opt.tree <- policy_tree(X[train, ], Gamma.matrix[train, ], depth = 2)
opt.tree

# Predict treatment on held out data.
predict(opt.tree, X[-train, ])
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/grf-labs/policytree}
  \item Report bugs at \url{https://github.com/grf-labs/policytree/issues}
}

}
\author{
\strong{Maintainer}: Erik Sverdrup \email{erikcs@stanford.edu}

Authors:
\itemize{
  \item Ayush Kanodia
  \item Zhengyuan Zhou
  \item Susan Athey
  \item Stefan Wager
}

}
\keyword{internal}
