% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logregR2.r
\name{logregR2}
\alias{logregR2}
\title{Logistic regression model statistics}
\usage{
logregR2(model, digits = 3)
}
\arguments{
\item{model}{An estimated logistic regression model}

\item{digits}{Number of digits to be displayed after decimal points}
}
\value{
Returns list of statistics about model (a "LogRegR2" class object)
}
\description{
Logistic regression model statistics
}
\examples{
   library(poliscidata)
   obama_state_model <- glm(obama_win12 ~ secularism + gunlaw_rank, data=states, family=binomial)
   summary(obama_state_model)
   logregR2(obama_state_model)
   
   obama_vote_model <- svyglm(obama_vote ~ ft_dem, design=nesD, family="quasibinomial")
   summary(obama_vote_model)
   logregR2(obama_vote_model)
}

