% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{nes}
\alias{nes}
\title{NES dataset for R Companion to Essentials of Political Analysis, Second Edition}
\format{A data frame with 5916 rows and 399 variables.
\describe{
  \item{abort_scale}{Anti-abortion Scale}
  \item{abort4}{Abortion Opinion: Self-Placement, 4 Categories}
  \item{abortpre_4point}{Abortion Opinion: Self-Placement, 4 Categories}
  \item{aidblack_self}{Support for Government assistance to blacks scale, 7 point scale }
  \item{auth_consid}{Child trait more important: considerate or well-behaved}
  \item{auth_cur}{Child trait more important: curiosity or good manners}
  \item{auth_ind}{Child trait more important: independence or respect}
  \item{auth_obed}{Child trait more important: obedience or self-reliance}
  \item{authoritarianism}{Authoritarianism (4 point scale based on child trait questions)}
  \item{black}{Is Respondent Black?}
  \item{budget_deficit_x}{Favor reducing the Federal budget deficit, 7 point scale}
  \item{caseid}{Case ID}
  \item{casistart_iwrset4}{Does Respondent have a dog (Interview set-up test)}
  \item{casistartpo_iwrset4}{Does Respondent have a dog (Interview set-up test)}
  \item{cog_opin_x}{Number of opinions Respondent has compared to average person}
  \item{congapp_job_x}{Approval of Congress}
  \item{congapp_jobst}{Strength of approve/disapprove Congress handling its job}
  \item{conservatism}{ftgr_cons minus ftgr_liberals}
  \item{cses_closepty}{Close to any political party?}
  \item{cses_contct}{Campaign mobilization: institutional contact}
  \item{cses_email}{Campaign mobilization: institutional contact - email}
  \item{cses_ftf}{Campaign mobilization: institutional contact - in person}
  \item{cses_gotv}{Respondent contacted by party/candidate?}
  \item{cses_govtact}{Support for government action income inequality (5 point scale)}
  \item{cses_govtact_3}{Government action on income inequality (3 point scale)}
  \item{cses_mail}{Campaign mobilization: institutional contact - by mail}
  \item{cses_mobph}{Campaign mobilization: sign up online information or alerts}
  \item{cses_perseml}{Campaign mobilization: personal contact - email}
  \item{cses_persftf}{Campaign mobilization: personal contact - in person}
  \item{cses_persmail}{Campaign mobilization: personal contact - by mail}
  \item{cses_persph}{Campaign mobilization: personal contact - by phone}
  \item{cses_perstxt}{Campaign mobilization: personal contact - text message}
  \item{cses_persuade}{Campaign mobilization: personal contact}
  \item{cses_persweb}{Campaign mobilization: personal contact - social network}
  \item{cses_phone}{Campaign mobilization: institutional contact - by phone}
  \item{cses_poliinffour}{Political information - Secretary of the U.N.}
  \item{cses_poliinfone}{Political information - Secretary of the Treasury}
  \item{cses_poliinfthree}{Political information - party 2nd in House seats won}
  \item{cses_polinf_x}{Pol info scale}
  \item{cses_polinftwo}{Political information - unemployment rate}
  \item{cses_polinftwo_date}{Political information - date used for date of unemployment rate}
  \item{cses_polinftwo_rate}{Political information - number used for unemployment rate}
  \item{cses_spending}{Econ conservatism (numeric scale)}
  \item{deathpen}{Death Penalty Opinion}
  \item{defsppr_self}{Support for defense spending, 7 point scale}
  \item{dem}{Party identification: Does Respondent self-identify as Democrat? (coded 0/1)}
  \item{dem_age_group_r}{Demographic: Age Groups}
  \item{dem_age3}{Demographic: Age group}
  \item{dem_age6}{Demographic: Six Age Groups}
  \item{dem_agegrp_iwdate}{Demographic: Respondent age on interview date (age group)}
  \item{dem_educ3}{Demographic: Education}
  \item{dem_edugroup}{Demographic: Respondent level of highest education}
  \item{dem_hisp}{Demographic: Is Respondent Spanish, Hispanic, or Latino}
  \item{dem_marital}{Demographic: Marital status}
  \item{dem_parents}{Demographic: Native status of parents}
  \item{dem_racecps_black}{Demographic: Race self-identification: mention Black}
  \item{dem_racecps_racedkrf}{Demographic: Race self-identification with don't know or refused to say}
  \item{dem_racecps_white}{Demographic: Race self-identification: mention White}
  \item{dem_raceeth}{Demographic: Respondent race and ethnicity group}
  \item{dem_raceeth2}{Demographic: White/Black}
  \item{dem_raceeth4}{Demographic: Respondent race and ethnicity group}
  \item{dem_unionhh}{Demographic: Anyone in household belong to labor union}
  \item{dem_veteran}{Demographic: Respondent ever served on active duty in Armed Forces}
  \item{dem2_numchild}{Demographic: Total Number of children in household}
  \item{dem3_ownhome}{Demographic: Does Respondent family own/rent home}
  \item{dem3_yearscomm}{Demographic: How many years has Respondent lived in this community?}
  \item{dhs_appterr_x}{Homeland security: Approve/disapprove of efforts to reduce terrorism}
  \item{dhs_attack}{Homeland security: Likely terrorist attack kill 100/more in next year?}
  \item{dhs_threat_x}{Homeland security: Is fed. gov't a threat to rights and freedoms? (numeric scale)}
  \item{dhs_threat3}{Homeland security: Is fed. gov't a threat to rights and freedoms?}
  \item{dhs_torture_x}{Homeland security: Favor/Oppose torture for suspected terrorists}
  \item{dhsinvolv_board}{Civic engagement: Has Respondent in past 4 years: attended city/school board meeting}
  \item{dhsinvolv_call}{Civic engagement: Has Respondent in past 4 years: called radio/TV about political issue}
  \item{dhsinvolv_contact1}{Civic engagement: Contact U.S. Representative or Senator}
  \item{dhsinvolv_letter}{Civic engagement: written a letter to newspaper/magazine about political issue}
  \item{dhsinvolv_march}{Civic engagement: Has Respondent joined a protest march}
  \item{dhsinvolv_message}{Civic engagement: sent Facebook/Twitter message about political issue}
  \item{dhsinvolv_netpetition}{Civic engagement: Has Respondent in past 4 years: sign internet petition}
  \item{dhsinvolv_org}{Civic engagement: Has Respondent in past 4 years: gave money to social/political organization}
  \item{dhsinvolv_petition}{Civic engagement: Has Respondent signed paper petition}
  \item{dhsinvolv_relig}{Civic engagement: Has Respondent in past 4 years: given money to religious organization}
  \item{discrim_blacks}{Discrimination: Amount against Blacks}
  \item{discrim_blacks_r}{Discrimination: Against Blacks? (yes/no)}
  \item{discrim_gays}{Discrimination: Amount against Gays and Lesbians?}
  \item{discrim_gays_r}{Discrimination: Against gays? (yes/no)}
  \item{discrim_hispanics}{Discrimination: Amount against Hispanics}
  \item{discrim_hispanics_r}{Discrimination: Against Hispanics? (yes/no)}
  \item{discrim_scale}{Discrimination: How much discrimination against blacks, gays, Hispanics, women? (Sum of yes answers)}
  \item{discrim_self}{Discrimination: How much discrimination faced personally?}
  \item{discrim_whites}{Discrimination: Amount against Whites}
  \item{discrim_women}{Discrimination: Amount against Women}
  \item{discrim_women_r}{Discrimination: Against women? (yes/no)}
  \item{discuss_disc}{Ever discuss politics with family or friends}
  \item{discuss_discpstwk}{Days in past week discussed politics}
  \item{ecblame_fmpr}{Economy: How much is former President to blame for poor economy?}
  \item{ecblame_pres}{Economy: How much is President to blame for poor economy?}
  \item{econ_ecnext_x}{Economy: U.S. economy better or worse 1 year from now}
  \item{econ_ecnextamt}{Economy: How much better/worse next 12 months}
  \item{econ_ecnow}{Economy: Currently good or bad}
  \item{econ_ecpast}{Economy: Better/worse in last year}
  \item{econ_ecpast_x}{Economy: Better or worse than 1 year ago}
  \item{econ_ecpastamt}{Economy: How much better/worse in last year}
  \item{econ_unlast}{Economy: How much unemployment better/worse in last year}
  \item{econ_unnext}{Economy: More/less unemployment in next year}
  \item{econ_unpast}{Economy: Unemployment better/worse in last year}
  \item{econ_unpast_x}{Economy: Unemployment better/worse than 1 year ago}
  \item{econcand_dwin}{Economy: Better/worse if Democratic Presidential candidate wins}
  \item{econcand_rwin}{Economy: Better/worse if Republican Presidential candidate wins}
  \item{ecperil_home}{How do you pay for your home?}
  \item{effic_carerev}{Political efficacy: Public officials don't care what people think}
  \item{effic_carestd}{Political efficacy: Public officials don't care what people think}
  \item{effic_complicrev}{Political efficacy: Politics/government too complicated to understand}
  \item{effic_complicstd}{Political efficacy: Politics/government too complicated to understand}
  \item{effic_external}{Political efficacy: External political efficacy (numeric scale)}
  \item{effic_external3}{Political efficacy: External political efficacy (3 categories)}
  \item{effic_internal}{Political efficacy: Internal political efficacy (numeric scale)}
  \item{effic_internal3}{Political efficacy: Internal political efficacy (3 categories)}
  \item{effic_sayrev}{Political efficacy: Have no say about what government does}
  \item{effic_saystd}{Political efficacy: Have no say about what government does}
  \item{effic_undrev}{Political efficacy: Good understanding of political issues}
  \item{effic_undstd}{Political efficacy: Good understanding of political issues}
  \item{efficpo_bothside}{Political efficacy: How often see both disagreeing parties as right}
  \item{egal_bigprob}{Equality: It's a big problem that we don't give equal chance to succeed}
  \item{egal_equal}{Equality: Society should make sure everyone has equal opportunity}
  \item{egal_fewerprobs}{Equality: If people were treated more fairly would be fewer problems}
  \item{egal_notbigprob}{Equality: Not a big problem if some have more chance in life}
  \item{egal_scale}{Equality: Egalitarianism (numeric scale)}
  \item{egal_scale_3}{Equality: Egalitarianism: 3 categories}
  \item{egal_toofar}{Equality: We have gone too far pushing equal rights}
  \item{egal_worryless}{Equality: We'd be better off if worried less about equality}
  \item{envir}{Environment: Environment more important response (on envjob_3) as 0/100}
  \item{envir_drill}{Environment: Favor/oppose increased U.S. offshore drilling}
  \item{envir_gwarm}{Environment: Is global warming happening or not}
  \item{envir_gwgood}{Environment: Rising temperatures good or bad}
  \item{envir_gwhow}{Environment: Anthropogenic climate change}
  \item{envir_nuke}{Environment: Should US have more/fewer nuclear power plants}
  \item{enviro.yes}{Environment: Environment more important response (on envjob_3) as 0/100}
  \item{envjob_3}{Environment: Environment or jobs more important?}
  \item{envjob_self}{Environment: 7 point scale environment-jobs tradeoff}
  \item{fairjob_opin_x}{Opinion about government ensuring fair jobs for blacks}
  \item{fedspend_child}{Federal budget increase/decrease: child care}
  \item{fedspend_childr}{Federal budget increase/decrease: child care (rev. scale)}
  \item{fedspend_crime}{Federal budget increase/decrease: crime control}
  \item{fedspend_crimer}{Federal budget increase/decrease: crime control (rev. scale)}
  \item{fedspend_enviro}{Federal budget increase/decrease: protecting environment}
  \item{fedspend_enviror}{Federal budget increase/decrease: protecting environment (rev. scale)}
  \item{fedspend_poor}{Federal budget increase/decrease: aid to the poor}
  \item{fedspend_poorr}{Federal budget increase/decrease: aid to the poor (rev. scale)}
  \item{fedspend_scale}{Federal Spending Scale (numeric scale, sum of increase responses)}
  \item{fedspend_schools}{Federal budget increase/decrease: public schools}
  \item{fedspend_schoolsr}{Federal budget increase/decrease: public schools (rev. scale)}
  \item{fedspend_scitech}{Federal budget increase/decrease: science and technology}
  \item{fedspend_scitechr}{Federal budget increase/decrease: science and technology (rev. scale)}
  \item{fedspend_ss}{Federal budget increase/decrease: Social Security}
  \item{fedspend_ssr}{Federal budget increase/decrease: Social Security (rev. scale)}
  \item{fedspend_welfare}{Federal budget increase/decrease: welfare programs}
  \item{fedspend_welfarer}{Federal budget increase/decrease: welfare programs (rev. scale)}
  \item{fem3}{Feeling about feminists (recode of ftgr_feminists into 3 categories)}
  \item{finance_finfam}{Financial situation: Respondent living with how many family members}
  \item{finance_finnext_x}{Financial situation: Better or worse off 1 year from now}
  \item{finance_finpast_x}{Financial situation: Better or worse off than 1 year ago}
  \item{ft_dem}{Feeling Thermometer: Democratic Party}
  \item{ft_dpc}{Feeling Thermometer: Democratic Presidential candidate}
  \item{ft_dvpc}{Feeling Thermometer: Democratic Vice-Presidential candidate}
  \item{ft_gwb}{Feeling Thermometer: G.W. Bush}
  \item{ft_hclinton}{Feeling Thermometer: Hillary Clinton}
  \item{ft_rep}{Feeling Thermometer: Republican Party}
  \item{ft_rpc}{Feeling Thermometer: Republican Presidential candidate}
  \item{ft_rvpc}{Feeling Thermometer: Republican Vice-Pres candidate}
  \item{ftcasi_asian}{Feeling thermometer: Asian-Americans}
  \item{ftcasi_black}{Feeling thermometer: Blacks}
  \item{ftcasi_hisp}{Feeling thermometer: Hispanics}
  \item{ftcasi_illegal}{Feeling thermometer: Illegal Immigrants}
  \item{ftcasi_white}{Feeling thermometer: Whites}
  \item{ftf_oversample}{Was Respondent a 2012 Time Series Oversample Case?}
  \item{ftgr_atheists}{Feeling thermometer: Atheists}
  \item{ftgr_bigbus}{Feeling thermometer: Big Business}
  \item{ftgr_catholics}{Feeling thermometer: Catholics}
  \item{ftgr_congress}{Feeling thermometer: Congress}
  \item{ftgr_cons}{Feeling thermometer: Conservatives}
  \item{ftgr_fedgov}{Feeling thermometer: Federal Government}
  \item{ftgr_fem3}{Feeling thermometer: Feminists (3 categories)}
  \item{ftgr_feminists}{Feeling thermometer: Feminists}
  \item{ftgr_gay}{Feeling thermometer: Gay Men and Lesbians}
  \item{ftgr_liberals}{Feeling thermometer: Liberals}
  \item{ftgr_middle}{Feeling thermometer: Middle Class People}
  \item{ftgr_military}{Feeling thermometer: The Military}
  \item{ftgr_mormons}{Feeling thermometer: Mormons}
  \item{ftgr_muslims}{Feeling thermometer: Muslims}
  \item{ftgr_poor}{Feeling thermometer: Poor People}
  \item{ftgr_rich}{Feeling thermometer: Rich People}
  \item{ftgr_tea}{Feeling thermometer: Tea Party}
  \item{ftgr_unions}{Feeling thermometer: Labor Unions}
  \item{ftgr_ussc}{Feeling thermometer: The U.S. Supreme Court}
  \item{ftgr_welfare}{Feeling thermometer: People on Welfare}
  \item{ftgr_working}{Feeling thermometer: Working Class People}
  \item{ftgr_xfund}{Feeling thermometer: Christian Fundamentalists}
  \item{ftgr_xian}{Feeling thermometer: Christians}
  \item{ftpo_dpcsp}{Feeling thermometer: Spouse of Democratic Presidential candidate}
  \item{ftpo_dvpc}{Feeling thermometer: Democratic Vice Presidential candidate}
  \item{ftpo_hdc}{Feeling thermometer: House Democratic Candidate}
  \item{ftpo_hoth}{Feeling thermometer: House Independent/3rd-party Candidate}
  \item{ftpo_hrc}{Feeling thermometer: House Republican Candidate}
  \item{ftpo_pres}{Feeling thermometer: Democratic Presidential candidate}
  \item{ftpo_roberts}{Feeling thermometer: John Roberts}
  \item{ftpo_rpc}{Feeling thermometer: Republican Presidential candidate}
  \item{ftpo_rpcsp}{Feeling thermometer: Spouse of Republican Presidential candidate}
  \item{ftpo_rvpc}{Feeling thermometer: Republican Vice Presidential candidate}
  \item{ftpo_sdc}{Feeling thermometer: Senate Democratic Candidate}
  \item{ftpo_senjr}{Feeling thermometer: Jr. Senator in State Without Race}
  \item{ftpo_sennot}{Feeling thermometer: Non-running Senator in State W/Race}
  \item{ftpo_sensr}{Feeling thermometer: Sr. Senator in State Without Race}
  \item{ftpo_soth}{Feeling thermometer: Senate Independent/3rd-party Candidate}
  \item{ftpo_src}{Feeling thermometer: Senate Republican Candidate}
  \item{gay_adopt}{Gay rights: gayrt_adopt==1. Yes}
  \item{gay_disc}{Gay rights: gayrt_discstd_x==1. Approve strongly}
  \item{gay_marry}{Gay rights: Approve same-sex marriage?}
  \item{gay_mil}{Gay rights: gayrt_milstd_x==1. Feel strongly that homosexuals should be allowed to serve}
  \item{gay_rights3}{Gay rights: Gay Rights Support (3 categories)}
  \item{gayrt_adopt}{Gay rights: Should gay and lesbian couples be allowed to adopt?}
  \item{gayrt_discrev_x}{Gay rights: favor laws against gays/lesbians job discrimination (rev.)}
  \item{gayrt_discstd_x}{Gay rights: favor laws against gays/lesbians job discrimination}
  \item{gayrt_marry}{Gay rights: Respondent position on gay marriage}
  \item{gayrt_milrev_x}{Gay rights: allow gays/lesbians serve in US armed forces (reversed)}
  \item{gayrt_milstd_x}{Gay rights: allow gays/lesbians serve in US armed forces}
  \item{gender}{Respondent's Gender}
  \item{govrole_scale}{Pro-government scale (numeric scale)}
  \item{guarpr_self}{Should gov't guarantee a job and standard of living? (7 point scale)}
  \item{gun_control}{Gun control: Should federal gov't make it more difficult to buy a gun?}
  \item{gun_control2}{Gun control: Make it more difficult to buy a gun?}
  \item{gun_importance}{Gun control: Importance of gun access issue to R}
  \item{gun_importance3}{Gun control: How important is gun issue?}
  \item{happ_lifesatisf}{How satisfied is Respondent with life?}
  \item{health_2010hcr_x}{Health care: Support 2010 health care law}
  \item{health_insured}{Health care: Does Respondent have health insurance}
  \item{health_self}{Health care: Health of Respondent}
  \item{health_smoke}{Health care: Smoked Cigarettes}
  \item{health_smokeamt}{Health care: If smoked, how many now}
  \item{hispanic}{Is Respondent Hispanic?}
  \item{hlthlaw_num}{Health care: Health Care Law effect on number insured}
  \item{hlthlaw_qual}{Health care: Health Care Law effect on health care services}
  \item{hseinc_approval}{Congress: Approve or disapprove of House incumbent}
  \item{hseinc_approval_x}{Congress: House incumbent approval}
  \item{hseinc_appstr}{Congress: How much approve House incumbent}
  \item{hseinc_disstr}{Congress: How much disapprove House incumbent}
  \item{hseinc_hinctouch}{Congress: How good a job does House incumbent do in district}
  \item{immig_checks}{Immigration: Opinion on immigration status checks on suspects}
  \item{immig_citizen}{Immigration: Opinion on allowing citizenship to some illegal aliens}
  \item{immig_policy}{Immigration: U.S. government policy toward unauthorized immigrants}
  \item{immigpo_jobs}{Immigration: How likely immigration will take away jobs}
  \item{immigpo_level}{Immigration: What should immigration levels be}
  \item{imports_limit}{Favor or oppose limits on foreign imports}
  \item{inc_incgroup_pre}{Respondent's family income }
  \item{incgroup_prepost}{Respondent's family income}
  \item{income5}{Respondent's income quintile}
  \item{indifference}{Indifference scale}
  \item{ineq_incgap_x}{Income gap size compared to 20 years ago}
  \item{ineqinc_ineqgb}{Is increased income inequality in U.S. good?}
  \item{ineqinc_ineqreduc}{Does Respondent favor/oppose government reducing income inequality?}
  \item{inspre_self}{Health care: Should care be insured by government or by private medical insurance? (7 point scale)}
  \item{involv_contact}{Involvement in politics: Contact congress?}
  \item{involv_message}{Involvement in politics: post political message?}
  \item{involv_numorgs_4}{Involvement in politics: Number of group memberships}
  \item{involv_org}{Involvement in politics: Give money to political organization?}
  \item{involv_petition}{Involvement in politics: Sign net petition?}
  \item{involv_voltr}{Involvement in politics: Has Respondent done any volunteer work in past 12 months?}
  \item{israel_support}{Is U.S. too supportive of Israel or not supportive enough}
  \item{knowl_housemaj}{Political knowledge: Know party with most members in House?}
  \item{knowl_senmaj}{Political knowledge: Know party with most members in Senate?}
  \item{libcon3}{Respondent's Political Ideology (3 categories)}
  \item{libcpo_self}{Respondent's Political Ideology (7 point scale)}
  \item{libcpre_ptyd}{Ideological placement of Democrats (7 point scale)}
  \item{libcpre_ptyr}{Ideological placement of Republicans (7 point scale)}
  \item{libcpre_rpc}{Ideological placement of Republican Pres. Candidate (7 point scale)}
  \item{libcpre_self}{Respondent's Political Ideology (7 point scale)}
  \item{libcpre_self_x}{Respondent's Political Ideology (7 point scale)}
  \item{link_black_scale}{Linked fate: blacks}
  \item{link_hisp_scale}{Linked fate: Hispanics}
  \item{link_oth_scale}{Linked fate: other people}
  \item{link_white_scale}{Linked fate: whites}
  \item{link_wom_scale}{Linked fate: women}
  \item{married}{Demographic: Is Respondent married?}
  \item{mobilpo_x}{Campaign mobilization: Respondent contacted by Party, Candidates, GOTV (numeric scale)}
  \item{mode}{Mode of interview (face-to-face or internet)}
  \item{modsex_disc}{Sex discrimination: How much job discrimination against women}
  \item{modsex_discamt}{Sex discrimination: Discrimination against women}
  \item{modsex_media_x}{Sex discrimination: How much attention media should pay to discrimination against women}
  \item{modsex_oppor_x}{Sex discrimination: Opportunities compared for women and men}
  \item{modsex_prob}{Sex discrimination: Do women complaining about discrimination cause more problems}
  \item{modsex_scale}{Sex discrimination: Modern sexism}
  \item{modsex_special}{Sex discrimination: Do women demanding equality seek special favors}
  \item{modsex_wommore}{Sex discrimination: How much more opportunities do women have}
  \item{mormon_xn}{Mormon a Christian religion?}
  \item{nesw}{Sampling weights: Weight variable}
  \item{nesw_rnd}{Sampling weights: Weight variable (rounded)}
  \item{obama_therm}{Obama Rating}
  \item{obama_vote}{Respondent vote for Obama?}
  \item{orientn_knowgay}{Sexual orientation of family and friends}
  \item{orientn_rgay}{Respondent's sexual orientation }
  \item{own_dog}{Does Respondent own a dog?}
  \item{owngun_owngun}{Does Respondent own a gun}
  \item{patriot_amident}{Patriotism: Important being American}
  \item{patriot_flag}{Patriotism: Emotion seeing flag fly}
  \item{patriot_love}{Patriotism: Love of country}
  \item{patriotism}{Patriotism scale}
  \item{penalty_dpenstr}{Strength Respondent favors/opposes death penalty}
  \item{penalty_favdpen}{Respondent favor/oppose death penalty}
  \item{penalty_favopp_x}{Favor death penalty?}
  \item{pid_3}{Party Identification, 3 categories}
  \item{pid_x}{Party Identification, 7 categories}
  \item{polknow_combined}{Political knowledge: Number political facts correct}
  \item{polknow3}{Political knowledge, 3 categories}
  \item{postvote_presvt}{Did Respondent vote for President}
  \item{postvote_presvtwho}{For whom did Respondent vote for President}
  \item{postvote_rvote}{Did Respondent vote in the November general election}
  \item{postvote_votehs}{Did Respondent vote for U.S. House of Representatives}
  \item{pot_legal}{Should marijuana be legal?}
  \item{pot_legal3}{Legalize marijuana?}
  \item{preknow_leastsp}{Political knowledge: Program that federal gov't spends the least on}
  \item{preknow_medicare}{Political knowledge: What is Medicare}
  \item{preknow_prestimes}{Political knowledge: Number of times president can be elected}
  \item{preknow_senterm}{Political knowledge: Years Senator Elected}
  \item{preknow_sizedef}{Political knowledge: Size of federal deficit }
  \item{preknow3}{Political knowledge, 3 categories}
  \item{pres_econ}{Presidential approval: Handling of economy (Recode of presapp_econ)}
  \item{pres_vote12}{Respondent's vote in 2012 presidential election}
  \item{presapp_econ_x}{Presidential approval: Handling of economy}
  \item{presapp_foreign}{Presidential approval: Handling of foreign relations}
  \item{presapp_foreign_x}{Presidential approval: Handling of foreign relations}
  \item{presapp_health_x}{Presidential approval: Handling of health care}
  \item{presapp_job_x}{Presidential approval: Handling of job}
  \item{presapp_scale}{Presidential approval scale}
  \item{presapp_war_x}{Presidential approval: Handling of war in Afghanistan}
  \item{presvote2012_2}{Respondent's vote in 2012 presidential election}
  \item{presvote2012_x}{Respondent's vote in 2012 presidential election}
  \item{preswin_care}{Care who wins Presidential Election}
  \item{preswin_dutychoice_x}{Does Respondent consider voting as duty/choice}
  \item{prevote_primv}{Did Respondent vote in the Presidential primary or caucus}
  \item{prevote_primvwho}{Which candidate did Respondent vote for in Pres. primary or caucus}
  \item{prochoice_scale}{Abortion: Pro-choice Scale}
  \item{relig_4cat}{Religion: Catholic, other Christian, other, or not religious?}
  \item{relig_attend}{Religion: Attend services}
  \item{relig_attend3}{Religion: Attend services}
  \item{relig_bornagn}{Religion: Does Christian Respondent consider self born-again?}
  \item{relig_guide}{Religion: Provides guidance in day-to-day living}
  \item{relig_imp}{Religion: Important to Respondent?}
  \item{relig_imp2}{Religion: Important to Respondent?}
  \item{relig_import}{Religion: Important part of Respondent's life}
  \item{relig_pray}{Religion: How often does Respondent pray}
  \item{relig_wordgod}{Religion: Is Bible word of God or men}
  \item{resent_deserve}{Black community: Agree/disagree blacks have gotten less than deserve}
  \item{resent_racial_scale}{Black community: Racial conservatism scale}
  \item{resent_slavery}{Black community: Agree/disagree past slavery make life more difficult}
  \item{resent_try}{Black community: Agree/disagree blacks must try harder to get ahead}
  \item{resent_workway}{Black community: Agree/disagree that blacks should work way up without special favors}
  \item{rvote2012_x}{Did Respondent vote in November general election?}
  \item{sample_district}{Respondent's Congressional district (in 113th U.S. Congress)}
  \item{sample_ftfpsu}{Sample strata: Primary sampling unit for face-to-face cases}
  \item{sample_state}{State of Respondent address}
  \item{science_use}{How often should gov't use scientific methods to solve problems?}
  \item{scourt_elim_x}{Should the Supreme Court be done away with?}
  \item{scourt_remove_x}{Should it be possible to remove Supreme Court justices?}
  \item{south}{Respondent from South?}
  \item{spsrvpr_ssself}{Support for government services/spending (7 point scale)}
  \item{strata_ftf}{Sample strata for face-to-face sample component}
  \item{strata_full}{Sample strata for full sample}
  \item{tarp_favopp_x}{Favor the TARP program?}
  \item{tea_supp_x}{Tea Party support}
  \item{trad_adjust}{Traditional values: Agree/disagree world is changing we should adjust}
  \item{trad_famval}{Traditional values: Agree/disagree that more emphasis needed on traditional family values}
  \item{trad_lifestyle}{Traditional values: Agree/disagree are newer lifestyles are breaking down society}
  \item{trad_tolerant}{Traditional values: Agree/disagree that one should be more tolerant of other moral standards}
  \item{trad_values_scale}{Traditional values: Moral traditionalism scale}
  \item{trust_social}{Trust: How often can people be trusted?}
  \item{trustgov_bigintrst}{Trust: Is government run by a few big interests or for benefit of all?}
  \item{trustgov_corrpt}{Trust: How many in government are corrupt?}
  \item{trustgov_trustgrev}{Trust: How often trust gov't in Wash to do what is right? (reversed)}
  \item{trustgov_trustgstd}{Trust: How often trust government in Wash to do what is right?}
  \item{trustgov_waste}{Trust: Does government waste much tax money?}
  \item{trustgvpo_crook}{Trust: How many in government are crooked?}
  \item{usworld_stay}{International relations: Country better off if we just stayed home}
  \item{usworld_stronger}{International relations: During last year, U.S. position in world is weaker/stronger/same?}
  \item{version}{ANES 2012 Time Series Release Version}
  \item{voted2008}{Did Respondent vote for President in 2008? (Recode of interest_voted2008)}
  \item{voted2012}{Did Respondent vote in 2012?}
  \item{voter_type}{Voter type (non, new, voter)}
  \item{weight_ftf}{Post-stratified weight for face-to-face cases, preliminary}
  \item{weight_full}{Post-stratified weight for full sample, preliminary release}
  \item{weight_web}{Post-stratified weight for web cases, preliminary release}
  \item{white}{Is Respondent white?}
  \item{wiretap_warrant}{Wiretaps: Favor or oppose authority to wiretap terrorism suspects?}
  \item{wiretappo_toofar}{Wiretaps: Has government power gone too far?}
  \item{women_bond_x}{Working women: Harder to establish bond with child?}
  \item{women_role}{Working women: Women's role (numeric scale)}
  \item{women_role_2}{Working women: Women's role at home or work?}
  \item{women_works_x}{Working women: Better if man works and woman takes care of home and family?}
  \item{wpres_gdbd_x}{How good/bad to have woman president in next 20 years?}
  \item{wt}{Sampling weight}
  \item{year}{ANES year}
}}
\source{
2012 American National Election Survey.  See Appendix Table A.2 of printed textbook for further information
}
\usage{
nes
}
\description{
The American National Election Survey polls individuals about their political beliefs and behavior. This dataset is used to demonstrate application of R to political analysis. See book Appendix for variable names and descriptions.
}
\keyword{datasets}

