% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/politenessProjection.R
\name{politenessProjection}
\alias{politenessProjection}
\title{Politeness projection}
\usage{
politenessProjection(df_polite_train, df_covar = NULL,
  df_polite_test = NULL, classifier = c("glmnet", "mnir"), ...)
}
\arguments{
\item{df_polite_train}{a data.frame with politeness features as outputed by \code{\link{politeness}} used to train model.}

\item{df_covar}{a data.frame with covariates.}

\item{df_polite_test}{optional data.frame with politeness features as outputed by \code{\link{politeness}} used for model testing. Must have same feature set as polite_train (most easily acheived by setting \code{dropblank=FALSE} in both call to \code{politeness}).}

\item{classifier}{name of classification algorithm. Defaults to "mnir" (see \code{mnlm}) but "glmnet" (see \code{glmnet}) is also available.}

\item{...}{additional parameters to be passed to the classification algorithm.}
}
\value{
List of df_polite_train and df_polite_test with projection. See details.
}
\description{
Projection of Multinomial Inverse Regression estimation for a politness matrix and covariates.
}
\details{
List:
\itemize{
\item train_proj matrix of projection of mlmn using df_covar and df_polite_train.
\item test_proj matrix of projection of mlmn using df_covar and df_polite_train on df_polite_test data.
\item train_coef coefficients of mnlm model using df_covar and df_polite_train.
}
}
\examples{

data("phone_offers")
data("bowl_offers")

polite.data<-politeness(phone_offers$message, parser="none",drop_blank=FALSE)

polite.holdout<-politeness(bowl_offers$message, parser="none",drop_blank=FALSE)

project<-politenessProjection(polite.data,
                              phone_offers$condition,
                              polite.holdout)

# Difference in average politeness across conditions in the new sample.

mean(project$test_proj[bowl_offers$condition==1])
mean(project$test_proj[bowl_offers$condition==0])

}
