% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q_function.R
\name{get_q_functions}
\alias{get_q_functions}
\title{Get Q-functions}
\usage{
get_q_functions(object)
}
\arguments{
\item{object}{Object of class \link{policy_eval} or \link{policy_object}.}
}
\value{
List of class \link{nuisance_functions}.
}
\description{
\code{get_q_functions()} returns a list of (fitted) Q-functions
associated with each stage.
}
\examples{
### Two stages:
source(system.file("sim", "two_stage.R", package="polle"))
d2 <- sim_two_stage(5e2, seed=1)
pd2 <- policy_data(d2,
                  action = c("A_1", "A_2"),
                  baseline = c("B"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd2

# evaluating the static policy a=1 using outcome regression
# based on a GLM model at each stage.
pe2 <- policy_eval(type = "or",
                   policy_data = pd2,
                   policy = policy_def(1, reuse = TRUE, name = "A=1"),
                   q_models = list(q_glm(), q_glm()))
pe2

# getting the Q-functions
q_functions <- get_q_functions(pe2)

# getting the fitted g-function values
head(predict(q_functions, pd2))
}
\seealso{
\link{predict.nuisance_functions}
}
