% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tonguelength.R
\name{tonguelength}
\alias{tonguelength}
\title{Converts ITD (cm) to tongue length for bees.}
\usage{
tonguelength(x, mouthpart = "all")
}
\arguments{
\item{x}{A dataframe with the following two columns: bee intertegular distance (IT) measurments in mm and Family, a vector of bee families. Only implemented 5 out of the extant 7 families: 
"Andrenidae", "Apidae", "Colletidae", "Halictidae", "Megachilidae".}

\item{mouthpart}{The mouth part you are interested in. Options are "all", glossa", "prementum" and "tongue" (i.e. gloss + prementum)}
}
\value{
A dataframe with bee tongue length (mm) and 95% confidence intervals are returned for each bees species along with your original dataframe.
}
\description{
Calculates tongue length (mm) from Cariveau et al. (2015) using intertegular distance (ITD) values (cm)..
}
\examples{
example=cbind.data.frame(IT=c(1.3,2.3),
                         Family=c("Andrenidae","Apidae"))
tonguelength(example,mouthpart="all")
}
\references{
Kendall et al. (2018)  Pollinator size and its consequences: Predictive allometry for pollinating insects. <doi:10.1101/397604>

Cariveau et al. (2016) The allometry of bee tongue length an its uses in ecology and evolution. PLoS ONE 11(3): e0151482 <doi:10.1371/journal.pone.0151482>
}
