% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\docType{methods}
\name{pmi}
\alias{pmi}
\alias{pmi,context-method}
\title{Calculate Pointwise Mutual Information (PMI).}
\usage{
pmi(.Object)

\S4method{pmi}{context}(.Object)
}
\arguments{
\item{.Object}{An object.}
}
\description{
Pointwise mutual information (PMI) is calculated as follows, see
Manning/Schuetze (1999) for an explanation:
\deqn{I(x,y) = log\frac{p(x,y)}{p(x)p(y)}}{I(x,y) = log(p(x,y)/(p(x)p(y)))}
Note that the computation uses log base 2, not the natural logarithm you find
in examples (e.g. \url{https://en.wikipedia.org/wiki/Pointwise_mutual_information}).
}
\examples{
y <- cooccurrences("REUTERS", query = "oil", method = "pmi")
N <- size(y)[["partition"]]
I <- log2((y[["count_coi"]]/N) / ((count(y) / N) * (y[["count_partition"]] / N)))
}
\references{
Manning, Christopher D.; Schuetze, Hinrich (1999): \emph{Foundations of Statistical Natural Language
Processing}. MIT Press: Cambridge, Mass., pp. 178-183.
}
\seealso{
See \code{\link{ll}}, \code{\link{chisquare}} and \code{\link{t_test}}.
}
