% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_function.R
\name{use}
\alias{use}
\title{Use a packaged corpus.}
\usage{
use(pkg = NULL, lib.loc = .libPaths(),
  dir = getOption("polmineR.defaultRegistry"))
}
\arguments{
\item{pkg}{package with a CWB indexed corpus to use (defaults to NULL)}

\item{lib.loc}{a character vector with path names of \code{R} libraries}

\item{dir}{a registry directory, defaults to \code{getOption("polmineR.defaultRegistry")}}
}
\value{
the function returns invisibly the registry that was previously set
}
\description{
Use a CWB corpus shipped in a package, or reset registry directory.
}
\details{
If \code{pkg} is the name of a data package with a CWB indexed corpus,
the function will reset the CORPUS_REGISTRY environment variable and restart
\code{rcqp} to point to the registry directory in the package.

If \code{pkg} is NULL (default), calling \code{use} will 
reset the registry directory to the directory defined by \code{dir}
(defaults to the option \code{polmineR.defaultRegistry}, to return to the registry
that was used when loading \code{polmineR}).
}
\seealso{
the worker to reset the registry is \code{\link{resetRegistry}}
}
