% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/corpus.R, R/count.R,
%   R/TermDocumentMatrix.R, R/kwic.R, R/enrich.R, R/format.R, R/view.R
\docType{class}
\name{kwic-class}
\alias{kwic-class}
\alias{[,kwic,ANY,ANY,ANY-method}
\alias{[,kwic-method}
\alias{get_corpus,kwic-method}
\alias{count,kwic-method}
\alias{as.DocumentTermMatrix,kwic-method}
\alias{as.TermDocumentMatrix,kwic-method}
\alias{show,kwic-method}
\alias{knit_print,kwic-method}
\alias{as.character,kwic-method}
\alias{subset,kwic-method}
\alias{as.data.frame,kwic-method}
\alias{length,kwic-method}
\alias{sample,kwic-method}
\alias{merge,kwic_bundle-method}
\alias{enrich,kwic-method}
\alias{format,kwic-method}
\alias{view,kwic-method}
\title{S4 kwic class}
\usage{
\S4method{get_corpus}{kwic}(x)

\S4method{count}{kwic}(.Object, p_attribute = "word")

\S4method{as.DocumentTermMatrix}{kwic}(x, p_attribute, verbose = TRUE, ...)

\S4method{as.TermDocumentMatrix}{kwic}(x, p_attribute, verbose = TRUE, ...)

\S4method{show}{kwic}(object)

\S4method{knit_print}{kwic}(x, options = knitr::opts_chunk)

\S4method{as.character}{kwic}(x, fmt = "<i>\%s</i>")

\S4method{[}{kwic,ANY,ANY,ANY}(x, i)

\S4method{subset}{kwic}(x, ...)

\S4method{as.data.frame}{kwic}(x)

\S4method{length}{kwic}(x)

\S4method{sample}{kwic}(x, size)

\S4method{merge}{kwic_bundle}(x)

\S4method{enrich}{kwic}(.Object, s_attributes = NULL, extra = NULL, table = FALSE, ...)

\S4method{format}{kwic}(
  x,
  node_color = "blue",
  align = TRUE,
  extra_color = "grey",
  lineview = getOption("polmineR.lineview")
)

\S4method{view}{kwic}(.Object)
}
\arguments{
\item{x}{A \code{kwic} class object.}

\item{.Object}{A \code{kwic} class object.}

\item{p_attribute}{A length-one \code{character} vector supplying a p-attribute.}

\item{verbose}{A \code{logical} value, whether to output debugging messages.}

\item{...}{Used for backwards compatibility.}

\item{object}{A \code{kwic} class object.}

\item{options}{Chunk options.}

\item{fmt}{A format string passed into \code{sprintf} to format the node of a
KWIC display.}

\item{i}{Single integer value, the kwic line for which the fulltext shall be
inspected.}

\item{size}{An \code{integer}, subset size for sampling.}

\item{s_attributes}{Character vector of s-attributes with metainformation.}

\item{extra}{An \code{integer} value, number of extra tokens to the left and
to the right of the windows of tokens to the left and right of a query
match that are decoded to be displayed in a kwic output to facilitate
interpretation.}

\item{table}{Logical, whether to turn cpos \code{data.table} into
\code{data.table} in slot \code{stat} for output.}

\item{node_color}{If not \code{NULL}, the html color of the node. If
supplied, the node will be wrapped in respective html tags.}

\item{align}{A \code{logical} value for preparing kwic output. If
\code{TRUE}, whether the content of the columns 'left', 'node' and 'right'
will be wrapped in html div elements that will align the output right,
centered and left, respectively.}

\item{extra_color}{If extra context has been generated using \code{enrich},
the html color of the additional output (defaults to 'grey').}

\item{lineview}{A \code{logical} value, whether to concatenate left context,
node and right context when preparing kwic output.}
}
\description{
S4 class for organizing information for kwic/concordance output. A set of
standard generics (\code{show}, \code{as.character}, \code{as.data.frame},
\code{length}, \code{sample}, \code{subset}) as well as indexing is implemented to process
kwic class objects (see 'Usage'). See section 'Details' for the
\code{enrich}, \code{view} and \code{knit_print} methods.
}
\details{
Applying the \code{count}-method on a \code{kwic} object will return
a \code{count} object with the evaluation of the left and right context of
the match.

The \code{knit_print} method will be called by knitr to render
\code{kwic} objects as a DataTable  \code{htmlwidget} when rendering a R
Markdown document as html. It will usually be necessary to explicitly state
"render = knit_print" in the chunk options. The option
\code{polmineR.pagelength} controls the number of lines displayed in the
resulting \code{htmlwidget}. Note that including htmlwidgets in html documents
requires that pandoc is installed. To avoid an error, a formatted
\code{data.table} is returned by \code{knit_print} if pandoc is not
available.

The \code{as.character}-method will return a list of \code{character} vectors,
concatenating the columns "left", "node" and "right" of the \code{data.table} in
the \code{stat}-slot of the input \code{kwic}-class object. Optionally, the node can
be formatted using a format string that is passed into \code{sprintf}.

The \code{subset}-method will apply \code{subset} to the table in the slot
\code{stat}, e.g. for filtering query results based on metadata (i.e.
s-attributes) that need to be present.

The \code{enrich} method is used to generate the actual output for
the kwic method. If param \code{table} is \code{TRUE}, corpus positions
will be turned into a \code{data.frame} with the concordance lines. If
param \code{s_attributes} is a character vector with s-attributes, the
respective s-attributes will be added as columns to the table with
concordance lines.

The \code{format}-method will return a \code{data.table} that can
serve as input for rendering a \code{htmlwidget}, for instance using
\code{DT::datatable} or \code{rhandsontable::rhandsontable}. It will
include html tags, so ensure that the rendering engine does not obfuscate
the html.
}
\section{Slots}{

\describe{
\item{\code{metadata}}{A \code{character} vector with s-attributes of the metadata
that are to be displayed.}

\item{\code{p_attribute}}{The p-attribute for which the context has been generated.}

\item{\code{left}}{An \code{integer} value, words to the left of the query match.}

\item{\code{right}}{An \code{integer} value, words to the right of the query match.}

\item{\code{corpus}}{Length-one \code{character} vector, the CWB corpus.}

\item{\code{cpos}}{A \code{data.table} with the columns "match_id", "cpos", "position",
"word_id", "word" and "direction".}

\item{\code{stat}}{A \code{data.table}, a table with columns "left", "node",
"right", and metadata, if the object has been enriched.}

\item{\code{encoding}}{A length-one \code{character} vector with the encoding of the
corpus.}

\item{\code{name}}{A length-one \code{character} vector naming the object.}

\item{\code{annotation_cols}}{A \code{character} vector designating the columns of
the \code{data.table} in the slot \code{table} that are annotations.}
}}

\examples{
use("polmineR")
K <- kwic("GERMAPARLMINI", "Integration")
get_corpus(K)
length(K)
K_min <- K[1]
K_min <- K[1:5]

# using kwic_bundle class
queries <- c("oil", "prices", "barrel")
li <- lapply(queries, function(q) kwic("REUTERS", query = q))
kb <- as.bundle(li)

# use count-method on kwic object
coi <- kwic("REUTERS", query = "oil") \%>\%
  count(p_attribute = "word")

# features vs cooccurrences-method (identical results)
ref <- count("REUTERS", p_attribute = "word") \%>\%
  subset(word != "oil")
slot(ref, "size") <- slot(ref, "size") - count("REUTERS", "oil")[["count"]]
y_features <- features(coi, ref, method = "ll", included = TRUE)
y_cooc <- cooccurrences("REUTERS", query = "oil")

# extract node and left and right context as character vectors
oil <- kwic("REUTERS", query = "oil")
as.character(oil, fmt = NULL)
as.character(oil) # node wrapped into <i> tag by default
as.character(oil, fmt = "<b>\%s</b>")

# subsetting kwic objects
oil <- corpus("REUTERS") \%>\%
  kwic(query = "oil") \%>\%
  subset(grepl("prices", right))
saudi_arabia <- corpus("REUTERS") \%>\%
  kwic(query = "Arabia") \%>\%
  subset(grepl("Saudi", left))
int_spd <- corpus("GERMAPARLMINI") \%>\%
  kwic(query = "Integration") \%>\%
  enrich(s_attribute = "party") \%>\%
  subset(grepl("SPD", party))

# turn kwic object into data.frame with html tags
int <- corpus("GERMAPARLMINI") \%>\%
  kwic(query = "Integration")

as.data.frame(int) # Without further metadata

enrich(int, s_attributes = c("date", "speaker", "party")) \%>\%
  as.data.frame()
  
# merge bundle of kwic objects into one kwic
reuters <- corpus("REUTERS")
queries <- c('"Saudi" "Arabia"', "oil", '"barrel.*"')
comb <- lapply(queries, function(qu) kwic(reuters, query = qu)) \%>\%
  as.bundle() \%>\%
  merge()
 
# enrich kwic object
i <- corpus("GERMAPARLMINI") \%>\%
  kwic(query = "Integration") \%>\%
  enrich(s_attributes = c("date", "speaker", "party"))
}
\seealso{
The constructor for generating kwic objects is the
\code{\link{kwic}} method.
}
