% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\docType{methods}
\name{terms}
\alias{terms}
\alias{terms,slice-method}
\alias{terms,partition-method}
\alias{terms,subcorpus-method}
\alias{terms,corpus-method}
\alias{terms,character-method}
\title{Get terms in \code{partition} or \code{corpus}.}
\usage{
\S4method{terms}{slice}(x, p_attribute, regex = NULL)

\S4method{terms}{partition}(x, p_attribute, regex = NULL)

\S4method{terms}{subcorpus}(x, p_attribute, regex = NULL)

\S4method{terms}{corpus}(x, p_attribute, regex = NULL, robust = FALSE)

\S4method{terms}{character}(x, p_attribute, regex = NULL, robust = FALSE)
}
\arguments{
\item{x}{A \code{corpus}, \code{partition} or \code{subcorpus} object, or a length-one
\code{character} with a corpus id.}

\item{p_attribute}{The p-attribute to for which to retrieve results
(length-one \code{character} vector).}

\item{regex}{Regular expression(s) to filter results (\code{character} vector).}

\item{robust}{A \code{logical} value, whether to check for potential failures.}
}
\description{
Get terms in \code{partition} or \code{corpus}.
}
\examples{
use("polmineR")
r <- partition("REUTERS", id = "144")
words <- terms(r, "word")
terms(r, p_attribute = "word", regex = ".*il.*")
}
