% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotpolyf.R
\name{plotpolyf}
\alias{plotpolyf}
\title{Plot Polygonal Domain on Image of Bivariate Function}
\usage{
plotpolyf(polyregion, f, ..., npixel = 100, cuts = 15,
  col = rev(heat.colors(cuts + 1)), lwd = 3, xlim = NULL, ylim = NULL,
  use.lattice = TRUE, print.args = list())
}
\arguments{
\item{polyregion}{a polygonal domain.
The following classes are supported:
\code{"\link[spatstat.geom]{owin}"} from package \pkg{spatstat.geom},
\code{"\link[rgeos:gpc.poly-class]{gpc.poly}"} from \pkg{rgeos} (or
\pkg{gpclib}),
\code{"\linkS4class{SpatialPolygons}"}, \code{"\linkS4class{Polygons}"},
and \code{"\linkS4class{Polygon}"} from package \pkg{sp}, as well as
\code{"\link[sf:st_polygon]{(MULTI)POLYGON}"} from package \pkg{sf}.
(For these classes, \pkg{polyCub} knows how to get an \code{\link{xylist}}.)}

\item{f}{a two-dimensional real-valued function.
As its first argument it must take a coordinate matrix, i.e., a
numeric matrix with two columns, and it must return a numeric vector of
length the number of coordinates.}

\item{...}{further arguments for \code{f}.}

\item{npixel}{numeric vector of length 1 or 2 setting the number of pixels
in each dimension.}

\item{cuts}{number of cut points in the \eqn{z} dimension.
The range of function values will be divided into \code{cuts+1} levels.}

\item{col}{color vector used for the function levels.}

\item{lwd}{line width of the polygon edges.}

\item{xlim, ylim}{numeric vectors of length 2 setting the axis limits.
\code{NULL} means using the bounding box of \code{polyregion}.}

\item{use.lattice}{logical indicating if \pkg{lattice} graphics
(\code{\link[lattice]{levelplot}}) should be used.}

\item{print.args}{a list of arguments passed to \code{\link[lattice]{print.trellis}}
for plotting the produced \code{\link[lattice:trellis.object]{"trellis"}} object
(given \code{use.lattice = TRUE}). The latter will be returned without
explicit \code{print}ing if \code{print.args} is not a list.}
}
\description{
Produces a combined plot of a polygonal domain and an image of a bivariate
function, using either \code{\link[lattice:levelplot]{lattice::levelplot}}
or \code{\link{image}}.
}
\examples{
### a polygonal domain (a simplified version of spatstat.data::letterR$bdry)
letterR <- list(
    list(x = c(2.7, 3, 3.3, 3.9, 3.7, 3.4, 3.8, 3.7, 3.4, 2, 2, 2.7),
         y = c(1.7, 1.6, 0.7, 0.7, 1.3, 1.8, 2.2, 2.9, 3.3, 3.3, 0.7, 0.7)),
    list(x = c(2.6, 2.6, 3, 3.2, 3),
         y = c(2.2, 2.7, 2.7, 2.5, 2.2))
)

### f: isotropic exponential decay
fr <- function(r, rate = 1) dexp(r, rate = rate)
fcenter <- c(2,3)
f <- function (s, rate = 1) fr(sqrt(rowSums(t(t(s)-fcenter)^2)), rate = rate)

### plot
plotpolyf(letterR, f, use.lattice = FALSE)
plotpolyf(letterR, f, use.lattice = TRUE)
}
\author{
Sebastian Meyer
}
\keyword{hplot}
