% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{split_linkage_info}
\alias{split_linkage_info}
\title{Split linkage information into homologues}
\usage{
split_linkage_info(all_linkages, marker_assignment, ploidy, log = NULL)
}
\arguments{
\item{all_linkages}{A list of linkage information divided by linkage group as output of \code{\link{finish_linkage_analysis}}.}

\item{marker_assignment}{A complete marker assignment \code{data.frame} containing all markers.}

\item{ploidy}{Integer. The ploidy level of the plant species.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
A nested list with linkage group on the first level and homologue on the second.
}
\description{
After running \code{\link{finish_linkage_analysis}} recombination frequency, LOD and phase are grouped by linkage group.
This functions classifies them into homologue within the linkage group.
}
\examples{
data("marker_assignments_P1", "all_linkages_list_P1")
splitted_list<-split_linkage_info(all_linkages_list_P1, marker_assignments_P1, 4)
}
