% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{maxL_IBD}
\alias{maxL_IBD}
\title{Wrapper function to run estimate_IBD function over multiple error priors}
\usage{
maxL_IBD(errors = c(0.01, 0.05, 0.1, 0.2), ...)
}
\arguments{
\item{errors}{Vector of offspring error priors to test (each between 0 and 1)}

\item{\dots}{Arguments passed to \code{\link{estimate_IBD}}.}
}
\value{
A list containing the following components:
\itemize{
\item{maxL_IBD : }{ A nested list as would have been returned by the estimate_IBD function, but composite across error priors to maximise the 
marginal likelihoods. Note that the $error values per linkage group are now the average error prior across the population per linkage group}
\item{MML : }{ A 3d array of the maximal marginal likelihoods, per error prior. Dimensions are individuals, linkage groups, error priors.}
\item{errors : }{ The error priors used (i.e. the input vector is returned for later reference.)}
}
}
\description{
Function to run the \code{\link{estimate_IBD}} function over a range of possible error priors. The function returns
a merged set of results that maximise the marginal likelihood per individual, i.e. allowing a per-individual error rate within the options
provided in the errors argument.
}
\examples{
\dontrun{
data("phased_maplist.4x","SNP_dosages.4x")
maxL_IBD(phased_maplist=phased_maplist.4x,genotypes=SNP_dosages.4x,
ploidy=4,errors=c(0.01,0.02,0.05,0.1))
}
}
