% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{plotLinearQTL_list}
\alias{plotLinearQTL_list}
\title{Overlay the results of a number of genome-wide QTL analysis for which significance thresholds are available.}
\usage{
plotLinearQTL_list(
  LOD_data.ls,
  inter_chm_gap = 5,
  ylimits = NULL,
  sig.unit = "LOD",
  plot_type,
  add_xaxis = TRUE,
  add_rug = TRUE,
  colours = c("black", "red", "dodgerblue", "sienna4"),
  ylab.at = 2.5,
  main.size = 2,
  main.lty = 1,
  thresh.lty = 3,
  thresh.lwd = 2,
  thresh.col = "darkred",
  return_plotData = FALSE,
  highlight_positions = NULL,
  LGdiv.col = "gray42",
  use_LG_names = TRUE,
  ...
)
}
\arguments{
\item{LOD_data.ls}{A list, each element of which is a separate output of \code{\link{QTLscan}}, for which the setting \code{perm_test = TRUE} was used each time.}

\item{inter_chm_gap}{The gap size (in cM) between successive chromosomes - by default a gap of 5 cM is used.}

\item{ylimits}{Use to specify ylimits of plot region, though by default \code{NULL} in which case a suitable plot region is automatically used.}

\item{sig.unit}{Label to use on the y-axis for significance units, by default assumed to be "LOD".}

\item{plot_type}{Plots can be either in line drawings or scatter plot format. If multiple types are required, supply as a vector of same length as LOD_data.ls}

\item{add_xaxis}{Should an x-axis be drawn? If multiple QTL analyses are performed on different traits, specifying this to be \code{FALSE}
and using \code{par(mar=c(0,4.1,4.1,2.1))} allows subsequent plots to be neatly stacked.}

\item{add_rug}{Logical, by default \code{TRUE} - should original marker points be added to plot?}

\item{colours}{Vector of colours to be used in the plotting. A default set of 4 colours is provided.}

\item{ylab.at}{Distance from the y-axis to place label (by default at 2.5 points)}

\item{main.size}{Size of line (or point) to plot the "main" data, the first set of results in the LOD_data.ls input list, by default 2.}

\item{main.lty}{Line type for the "main" data, by default a normal line (lty = 1).}

\item{thresh.lty}{Gives user control over the line type of the significance threshold to be drawn.}

\item{thresh.lwd}{Gives user control over the line width of the significance threshold to be drawn.}

\item{thresh.col}{Gives user control over the line colour of the significance threshold to be drawn, by default "darkred"}

\item{return_plotData}{Logical, by default \code{FALSE}. If \code{TRUE}, then the x and y coordinates of the plot data are returned,
which can be useful for subsequent plot manipulations and overlays.}

\item{highlight_positions}{Option to include a list of associated positions to highlight, of the same length and in the same order as \code{LOD_data.ls}.
Each set of positions should be provided in data.frame format with 3 columns corresponding to linkage group, type and ID (same format as the cofactor.df 
argument of function \code{\link{QTLscan}}. This can be useful if genetic co-factor analyses are being compared. 
If no position is to be highlighted, add the corresponding list element as \code{NULL}.}

\item{LGdiv.col}{Colour of dividing lines between linkage groups, by default grey.}

\item{use_LG_names}{Logical, by default \code{TRUE}. Should original character LG names be used as axis labels, or should numbering be used instead?}

\item{\dots}{Arguments passed to \code{\link{lines}} or \code{\link{points}} as appropriate (see argument plot_type).}
}
\value{
The plot data, if \code{return_plotData = TRUE}, otherwise \code{NULL}
}
\description{
Extension of the \code{\link{plotLinearQTL}} function, taking as input a list generated from combining the output of \code{\link{QTLscan}}.
Its distinguishing characteristic is that overlaid plots are re-scaled so that the significance thresholds overlap. This can be useful if there are multiple results
being plotted together for comparison, all of which may have different thresholds. The resulting plot can help quickly compare the power of different analyses. Warning - 
the y axis LOD scale is only correct for the first list element / set of results. Also as before, this function only works for QTL scan over multiple chromosomes.
}
\examples{
\dontrun{
data("qtl_LODs.4x")
## Introduce some arbitrary noise for the sake of this example:
qtl_LODs.4x_2 <- qtl_LODs.4x
qtl_LODs.4x_2$Perm.res$threshold <- 2.5
qtl_LODs.4x_2$QTL.res$LOD<-qtl_LODs.4x_2$QTL.res$LOD+rnorm(length(qtl_LODs.4x_2$QTL.res$LOD),2)
plotLinearQTL_list(list(qtl_LODs.4x,qtl_LODs.4x_2),plot_type="lines")
}
}
