% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_stochchastic.R
\name{round_stochastic}
\alias{round_stochastic}
\title{Round a stochastic vector or a row-stochastic matrix}
\usage{
round_stochastic(x, digits = getOption("digits"))
}
\arguments{
\item{x}{a stochastic vector or a row-stochastic matrix.}

\item{digits}{number of digits for rounding.}
}
\value{
The rounded vector or matrix.
}
\description{
Rounds a vector such that the sum of 1 is preserved. Rounds a matrix such
that the rows still sum up to 1.
}
\details{
Rounds and adjusts one entry such that the rounding error is the smallest.
}
\examples{
# a vector that is off by 1e-8
x <- c(0.25 + 1e-8, 0.25, 0.5)

round_stochastic(x)
round_stochastic(x, digits = 2)
round_stochastic(x, digits = 1)
round_stochastic(x, digits = 0)
}
\seealso{
\link{round}
}
