% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\docType{methods}
\name{load}
\alias{load}
\alias{pompLoad}
\alias{pompUnload}
\alias{solibs<-}
\alias{pompLoad,pomp-method}
\alias{pompUnload,pomp-method}
\alias{solibs<-,pomp-method}
\title{Loading and unloading shared-object libraries}
\usage{
\S4method{pompLoad}{pomp}(object, ...)

\S4method{pompUnload}{pomp}(object, ...)

\S4method{solibs}{pomp}(object, ...) <- value
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or extending this class.}
}
\description{
\code{pompLoad} and \code{pompUnload} cause compiled codes associated with \code{object} to be dynamically linked or unlinked, respectively.
\code{solibs<-} is a helper function for developers of packages that extend \pkg{pomp}.
}
\details{
When C snippets are used in the construction of a \sQuote{pomp} object, the resulting shared-object library is dynamically loaded (linked) before each use, and unloaded afterward.

\code{solibs<-} prepends the \sQuote{lib} generated by \code{\link{hitch}}
 to the \sQuote{solibs} slot of a \sQuote{pomp} object.
}
\keyword{internal}
