% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{as.data.frame.ratetable}
\alias{as.data.frame.ratetable}
\title{Coerce a \code{ratetable} object to \code{data.frame}}
\usage{
\method{as.data.frame}{ratetable}(x, ...)
}
\arguments{
\item{x}{a \code{ratetable}}

\item{...}{unused but added for compatibility with \code{as.data.frame}}
}
\description{
\code{ratatable} objects used in e.g. \pkg{survival} and \pkg{relsurv}
can be conveniently coerced to a long-format \code{data.frame}.
However, the names and levels of variables in the result
may not match names and levels of variables in your data.
}
\examples{
library(relsurv)
data(slopop)
df <- as.data.frame.ratetable(slopop)
head(df)
}
\author{
Joonas Miettinen
}
\seealso{
\code{\link[survival]{ratetable}},
\code{\link{as.data.table.ratetable}}
}

