% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_definitions.R
\name{summary.survtab}
\alias{summary.survtab}
\title{Summarize a survtab Object}
\usage{
\method{summary}{survtab}(object, t = NULL, subset = NULL, q = NULL, ...)
}
\arguments{
\item{object}{a \code{survtab} object}

\item{t}{a vector of times at which time points to print
summary table of survival function estimates by strata;
will automatically use values in breaks used to split data
for aggregation closest to these values, so e.g. supplyig 
\code{t = c(2.5, 5.1)}
with data that was split by the breaks \code{seq(0, 5, 1/12)}
causes the times \code{c(2.5, 5.0)} to be used. 
Since the estimates at the time points closest to \code{t} are selected,
values of \code{t} are compared with column \code{Tstop} in the data.
If \code{NULL}, prints all rows.}

\item{subset}{a logical condition to subset results table by
before printing; use this to limit to a certain stratum. E.g.
\code{subset = sex == "male"}}

\item{q}{a named \code{list} of quantiles to include in returned data set.
E.g. \code{list(surv.obs = 0.5)} for rows closest to the median survival
for each strata in the \code{survtab} object. See Examples.}

\item{...}{unused; required for congruence with other \code{summary} methods}
}
\description{
Summary method function for \code{survtab} objects; see
\code{\link{survtab_ag}}. Returns estimates at given time points
or all time points.
}
\examples{

library(Epi)
library(survival)

## NOTE: recommended to use factor status variable
x <- Lexis(entry = list(FUT = 0, AGE = dg_age, CAL = get.yrs(dg_date)), 
           exit = list(CAL = get.yrs(ex_date)), 
           data = sire[sire$dg_date < sire$ex_date, ],
           exit.status = factor(status, levels = 0:2, 
           labels = c("alive", "canD", "othD")), 
           merge = TRUE)
## pretend some are male
set.seed(1L)
x$sex <- rbinom(nrow(x), 1, 0.5)
## observed survival
st <- survtab(Surv(time = FUT, event = lex.Xst) ~ sex, data = x, 
                  surv.type = "cif.obs",
                  breaks = list(FUT = seq(0, 5, 1/12)))

## estimates at full years of follow-up
summary(st, t = 1:5)

## interval estimate closest to 75th percentile 
## (just switch 0.75 to 0.5 for median survival, etc.)
summary(st, q = list(surv.obs = 0.75))
## multiple quantiles
summary(st, q = list(surv.obs = c(0.75, 0.90), CIF_canD = 0.20))

## if you want all estimates in a new data.frame, you can also simply do

x <- as.data.frame(st)

}
\author{
Joonas Miettinen
}

