% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series-funs.R
\name{filter_series}
\alias{filter_series}
\title{Extract the count series corresponding to a location and/or a species}
\usage{
filter_series(data, species = NULL, location = NULL)
}
\arguments{
\item{data}{a named \code{list}. The output of function \code{\link[=format_data]{format_data()}}.}

\item{species}{a \code{character} string. A species name.}

\item{location}{a \code{character} string. A site name.}
}
\value{
A subset of \code{data}, i.e. a named \code{list}.
}
\description{
This function identifies the count series relative to a species and/or
a location in a named list like the output of function \code{\link[=format_data]{format_data()}}. If
both species and location are provided, the series of counts of the species
at the specified location is extracted. Otherwise, all series corresponding
to the specified criterion (species or location) are extracted.
}
\examples{
## Load Garamba raw dataset ----
file_path <- system.file("extdata", "garamba_survey.csv", 
                         package = "popbayes")
                         
garamba <- read.csv(file = file_path)

## Create temporary folder ----
temp_path <- tempdir()

## Format dataset ----
garamba_formatted <- popbayes::format_data(garamba, path = temp_path)

## Number of count series ----
length(garamba_formatted)

## Retrieve count series names ----
popbayes::list_series(path = temp_path)

## Get data for Alcelaphus buselaphus (at all sites) ----
x <- popbayes::filter_series(garamba_formatted, 
                             species = "Alcelaphus buselaphus")

## Get data at Garamba (for all species) ----
x <- popbayes::filter_series(garamba_formatted, 
                             location = "Garamba")

## Get data for Alcelaphus buselaphus at Garamba only ----
x <- popbayes::filter_series(garamba_formatted, 
                             location = "Garamba",
                             species  = "Alcelaphus buselaphus")
}
