% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image2.R
\name{image2}
\alias{image2}
\title{Display a matrix image}
\usage{
image2(x, col = c("white", rev(heat.colors(23))), breaks, log = TRUE,
  border = NA, box.offset = 0.1, round = 3, cex, text.cex = 1,
  text.col = "black", mar = c(1, 3, 3, 1), labels = 2:3,
  label.offset = 0.1, label.cex = 1, srt = 90)
}
\arguments{
\item{x}{A numeric matrix with row and column names}

\item{col}{A vector of colors for boxes}

\item{breaks}{A numeric vector of break points or number of intervals into
which \code{x} is to be \code{\link{cut}}. Default is the length of \code{col}}

\item{log}{Cut values in \code{x} using a log scale, default TRUE}

\item{border}{The border color for boxes, default is no borders}

\item{box.offset}{Percent reduction in box size (a number between 0 and 1),
default is 10\% reduction}

\item{round}{Number of decimal places to display values of \code{x} in each box}

\item{cex}{Magnification size of text and labels, if specified this will
replace values in both text.cex and label.cex}

\item{text.cex}{Magnification size of text in cells only}

\item{text.col}{Color of text in cells, use NA to skip text labels}

\item{mar}{Margins on four sides of plot}

\item{labels}{A vector giving sides of the plot (1=bottom, 2=left, 3=top,
4=right) for row and column labels}

\item{label.offset}{Amount of space between label and boxes}

\item{label.cex}{Magnification size of labels}

\item{srt}{String rotation for labels on top and bottom of matrix}
}
\value{
A image plot of the matrix
}
\description{
Creates a grid of colored rectangles to display a projection, elasticity,
sensitivity or other matrix.
}
\note{
#' The minimum value in \code{x} is usually assigned to the first color
category and the rest of the values are then cut into equally spaced
intervals.  This was added to show transitions with very low probabilities in
a new color category, eg, 2e-06 would usually be grouped with 0 using
\code{\link{image}}. Note if all elements > 0, then the first color will not
be used.
}
\examples{
A <- calathea[[11]]
op <- par(mfrow=c(2,2))
image2(A, text.cex=.8)
## with  gray border and labels on bottom right
image2( A, text.cex=.8, border="gray70", labels=c(1,4), mar=c(3,1,1,3))
## no text or box offset
image2( A, box.offset=0, text.col=NA)
# set zeros to NA to print everything but zero
A[A == 0] <- NA
image2( A, box.offset=0 , text.cex=.8)
## if comparing two or more matrices, get the log10 range
## of values (not including zero) and pass to breaks
x <- unlist(calathea[-17])
x <- log10(range(x[x!=0]))
par(mfrow=c(4,4))
for(i in 1:16){
  A <- calathea[[i]]
  A[A == 0] <- NA
  image2(A, cex=.7, box.offset=0, breaks=seq(x[1], x[2], len=24))
    title(names(calathea[i]), line=3)
}
par(op)

}
\seealso{
\code{\link{image}}
}
\author{
Chris Stubben
}
