% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.reproductive.rate.R
\name{net.reproductive.rate}
\alias{net.reproductive.rate}
\title{Net reproductive rate}
\usage{
net.reproductive.rate(A, ...)
}
\arguments{
\item{A}{projection matrix}

\item{\dots}{additional items are passed to \code{\link{splitA}} and are
used to split A into T and F matrices}
}
\value{
Net reproductive rate.  If the transition matrix is singular, then
NA is returned.
}
\description{
Calculates the net reproductive rate of a stage classified matrix using the
dominant eigenvalue of the matrix R
}
\examples{
net.reproductive.rate(whale)
## fertilities in last column
net.reproductive.rate(teasel, r=1:6, c=6)
## Plot 3 from Calathea - values are not the same as p. 105 in Caswell.
sapply(calathea[9:12], net.reproductive.rate)

}
\references{
Caswell, H. 2001. Matrix population models: construction,
analysis, and interpretation, Second edition. Sinauer, Sunderland,
Massachusetts, USA.
}
\seealso{
see \code{\link{fundamental.matrix}} and \code{\link{generation.time}}
for other age-specific traits
}
\author{
Chris Stubben
}
