% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inertia.R
\name{inertia}
\alias{inertia}
\title{Calculate population inertia}
\usage{
inertia(A, vector = "n", bound = NULL, return.N = FALSE, t = NULL)
}
\arguments{
\item{A}{a square, primitive, irreducible, non-negative numeric matrix of any 
dimension}

\item{vector}{(optional) a numeric vector or one-column matrix describing 
the age/stage distribution ('demographic structure') used to calculate a 
'case-specific' maximal amplification}

\item{bound}{(optional) specifies whether an upper or lower bound should be 
calculated (see details).}

\item{return.N}{(optional) if \code{TRUE}, returns population size for a 
specified \code{t} (including effects of asymptotic growth and initial 
population size), alongside standardised inertia.}

\item{t}{(optional) the projection interval at which \code{N} is to be 
calculated.  Calculation of \code{N} is only accurate for \code{t} where the 
model has converged (see details)}
}
\value{
If \code{vector="n"}, the upper bound on inertia of \code{A} if 
\code{bound="upper"} and the lower bound on inertia of \code{A} if 
\code{bound="lower"}.\cr
If \code{vector} is specified, the case-specific inertia of the model.\cr
If \code{return.N=TRUE} and \code{t} is specified, a list with components:
\describe{
\item{inertia}{the bound on or case-specific inertia}
\item{N}{the population size at specified \code{t}.}
}
}
\description{
Calculate population inertia for a population matrix projection model.
}
\details{
A nonstable population, when it achieves asymptotic growth following transient 
dynamics, is a fixed ratio of the size of a population projected with the same
initial size but stable structure. \code{inertia} calculates the value of this
ratio (Koons et al. 2007)

If \code{vector="n"} then either \code{bound="upper"} or \code{bound="lower"}
must be specified, which calculate the upper or lower bound on population 
inertia (i.e. the largest and smallest values that inertia may take) 
respectively. Specifying \code{vector} overrides calculation of a bound, and 
will yield a 'case-specific' value for inertia.

\code{inertia} will not work with imprimitive or reducible matrices.
}
\examples{
  # Create a 3x3 PPM
  ( A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3) )

  # Create an initial stage structure
  ( initial <- c(1,3,2) )

  # Calculate the upper bound on inertia of A
  inertia(A,bound="upper")

  # Calculate the lower bound on inertia of A
  inertia(A,bound="lower")

  # Calculate case-specific inertia of A and initial
  inertia(A, vector=initial)

  # Calculate case-specific inertia of A and initial and 
  # return realised population size at t=25
  inertia(A, vector=initial, return.N=TRUE, t=25)

}
\references{
\itemize{
 \item Koons et al. (2007) Ecology, 88, 2867-2867.
 \item Stott et al. (2011) Ecol. Lett., 14, 959-970.
}
}
\seealso{
Transfer function methods for inertia: \code{\link{inertia.tfa}}, 
\code{\link{inertia.tfamatrix}}, \code{\link{inertia.tfsens}}, 
\code{\link{inertia.tfsensmatrix}}

Other TransientIndices: \code{\link{Kreiss}},
  \code{\link{maxamp}}, \code{\link{maxatt}},
  \code{\link{reac}}
}
\concept{
transient amplification attenuation unstable instability stable equivalent ratio
}
