% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ia_jackknife.R
\name{boot.ia}
\alias{boot.ia}
\title{Bootstrap the index of association}
\usage{
boot.ia(gid, how = "partial", reps = 999, quiet = FALSE, ...)
}
\arguments{
\item{gid}{a genind or genclone object}

\item{how}{method of bootstrap. The default \code{how = "partial"} will include
all the unique genotypes and sample with replacement from the unique
genotypes until the total number of individuals has been reached. Using
\code{how = "full"} will randomly sample with replacement from the data as it
is. Using \code{how = "psex"} will sample from the full data set after first
weighting the samples via the probability of encountering the nth occurence
of a particular multilocus genotype. See \code{\link[=psex]{psex()}} for details.}

\item{reps}{an integer specifying the number of replicates to perform.
Defaults to 999.}

\item{quiet}{a logical. If \code{FALSE}, a progress bar will be displayed. If
\code{TRUE}, the progress bar is suppressed.}

\item{...}{options passed on to \code{\link[=psex]{psex()}}}
}
\value{
a data frame with the index of association and standardized index of
association in columns. Number of rows represents the number of reps.
}
\description{
This function will perform the index of association on a bootstrapped data
set multiple times to create a distribution, showing the variation of the
index due to repeat observations.
}
\note{
This function is experimental. Please do not use this unless you know
what you are doing.
}
\examples{
data(Pinf)
boot.ia(Pinf, reps = 99)
}
\seealso{
\code{\link[=ia]{ia()}},
\code{\link[=pair.ia]{pair.ia()}},
\code{\link[=psex]{psex()}}
}
