% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IndividualData.R
\name{get_stake_data}
\alias{get_stake_data}
\title{Return cleaned Portal rodent individual data}
\usage{
get_stake_data(path = "~", clean = TRUE, type = "Rodents",
  length = "all", unknowns = FALSE, time = "period",
  fillweight = FALSE, min_plots = 1, min_traps = 1,
  download_if_missing = TRUE)
}
\arguments{
\item{path}{path to location of downloaded Portal data; or "repo" to
retrieve data from github repo}

\item{clean}{logical, load only QA/QC rodent data (TRUE) or all data (FALSE)}

\item{type}{specify subset of species; either all "Rodents" or only
"Granivores"}

\item{length}{specify subset of plots; use "All" plots or only "Longterm"
plots (plots that have had same treatment for entire time series)}

\item{unknowns}{either removes all individuals not identified to species
(unknowns = FALSE) or sums them in an additional column (unknowns = TRUE)}

\item{time}{specify the format of the time index in the output, either
"period" (sequential Portal surveys), "newmoon" (lunar cycle numbering),
"date" (calendar date)}

\item{fillweight}{specify whether to fill in unknown weights with other
records from that individual or species, where possible}

\item{min_plots}{minimum number of plots within a period for an
observation to be included}

\item{min_traps}{minimum number of plots within a period for an
observation to be included}

\item{download_if_missing}{if the specified file path doesn't have the
PortalData folder, then download it}
}
\value{
a data.frame
}
\description{
This function cleans and subsets the data based on a number
  of arguments. It returns stake number and individual level data.
}
