% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_helper.R
\name{cross_fit_helper}
\alias{cross_fit_helper}
\title{Helper function to for cross-fitting}
\usage{
cross_fit_helper(model_W, model_Y, folds_to_fit, use)
}
\arguments{
\item{model_W}{The model used to produce the estimates of W_hat}

\item{model_Y}{The model used to produce the estimates of Y_hat}

\item{folds_to_fit}{The split folds for which the calculations are being run.}

\item{use}{The method to use when calculating the out of fold prediction (propagates from method).}
}
\value{
A list with four elements: The mean estimate of \eqn{\theta}, the standard error of the mean estimate, the associated  moment conditions, and the estimated heterogenous effects for the single batch of a single run of the simulation.
}
\description{
Fits estimated models to out of fold samples
}
\examples{


n = 1000
p = 10
X = matrix(rnorm(n*p),n,p)
W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)

fit_on <- sample(1:1000, size = 333)
pred_on_1 <- sample(c(1:1000)[-fit_on], size = 333)
pred_on_2 <- c(1:1000)[-c(fit_on,pred_on_1)]
models <- ols_helper( X = X[fit_on,],
                      Y = Y[fit_on],
                      W = W[fit_on] )

folds_fit <- list()
folds_fit[[1]] <- data.frame(cbind(pred_on_1, X[pred_on_1,], W[pred_on_1], Y[pred_on_1]))
folds_fit[[2]] <- data.frame(cbind(pred_on_2, X[pred_on_2,], W[pred_on_2], Y[pred_on_2]))

for(i in 1:length(folds_fit)){
  names( folds_fit[[i]] ) <- c("sample_id","Y_t", paste("X_t_", 1:ncol(X), sep = ""), "W_t")
  }

cross_fit_helper( model_W = models[[1]],
                  model_Y = models[[2]],
                  folds_to_fit = folds_fit,
                  use = "ols")


}
