% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{quantile2}
\alias{quantile2}
\alias{quantile2.default}
\alias{quantile2.rvar}
\title{Compute Quantiles}
\usage{
quantile2(x, probs = c(0.05, 0.95), na.rm = FALSE, ...)

\method{quantile2}{default}(x, probs = c(0.05, 0.95), na.rm = FALSE, names = TRUE, ...)

\method{quantile2}{rvar}(x, probs = c(0.05, 0.95), na.rm = FALSE, names = TRUE, ...)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{probs}{(numeric vector) Probabilities in \verb{[0, 1]}.}

\item{na.rm}{(logical) Should \code{NA} and \code{NaN} values be removed from \code{x} prior
to computing quantiles? The default is \code{FALSE}.}

\item{...}{Arguments passed to individual methods (if applicable) and then
on to \code{\link[stats:quantile]{stats::quantile()}}.}

\item{names}{(logical) Should the result have a \code{names} attribute? The
default is \code{TRUE}, but use \code{FALSE} for improved speed if there are many
values in \code{probs}.}
}
\value{
A numeric vector of length \code{length(probs)}. If \code{names = TRUE}, it has a
\link{names} attribute with names like \code{"q5"}, \code{"q95"}, etc, based on the values
of \code{probs}.
}
\description{
Compute quantiles of a sample and return them in a format consistent
with other summary functions in the \pkg{posterior} package.
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
quantile2(mu)

}
