% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_bind.R
\name{post_bind}
\alias{post_bind}
\title{Combine two objects containing posterior samples}
\usage{
post_bind(post1, post2, dup_id = "_p2")
}
\arguments{
\item{post1}{A \code{\link[coda:mcmc.list]{mcmc.list}} or \code{\link[base:matrix]{matrix}} object.}

\item{post2}{A \code{\link[coda:mcmc.list]{mcmc.list}} or \code{\link[base:matrix]{matrix}} object.}

\item{dup_id}{If any node names are duplicated in \code{post2}, what should be appended to the
end of these node names in the output? If this occurs a warning will be returned.
Defaults to \code{"_p2"}}
}
\value{
A single \code{\link[coda:mcmc.list]{mcmc.list}} object containing samples of the nodes from both \code{post1} and \code{post2}.
}
\description{
Intended for use when derived quantities are calculated from monitored posterior samples,
and you wish to combine them into the master \code{\link[coda:mcmc.list]{mcmc.list}},
as though they were calculated and monitored during MCMC sampling.
It is not advised to combine samples from two MCMC runs, because covariance
of MCMC sampling would be lost.
}
\details{
Some important things to note:
\itemize{
\item If the object passed to \code{post1} is a \code{\link[base:matrix]{matrix}}, \code{post2} must be a \code{\link[coda:mcmc.list]{mcmc.list}}, and vice versa.
\item That is, two \code{\link[coda:mcmc.list]{mcmc.list}} objects are allowed, but not two \code{\link[base:matrix]{matrix}} objects.
\item For \code{\link[base:matrix]{matrix}} objects, nodes should be stored as columns and samples should be stored as rows. Column names should be present.
\item The objects passed to \code{post1} and \code{post2} must have the same number of chains, iterations, burnin, and thinning interval.
\item If the node names are empty (e.g., missing column names in a \code{\link[base:matrix]{matrix}}), the node names will be coerced to \code{"var1"}, \code{"var2"}, etc. and a warning will be returned.
}
}
\examples{
# load example mcmc.list
data(cjs)

# create two subsets from cjs: one as mcmc.list and one as matrix
# also works if both are mcmc.list objects
p1 = post_subset(cjs, "b0")
p2 = post_subset(cjs, "b1", matrix = TRUE)

# combine them into one mcmc.list
head(post_bind(p1, p2))
}
