% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.powdRlib}
\alias{subset.powdRlib}
\title{Subset a powdRlib object}
\usage{
\method{subset}{powdRlib}(x, refs, mode, ...)
}
\arguments{
\item{x}{a \code{powdRlib} object.}

\item{refs}{a string of the phase ID's or names of reference patterns to be subset. The ID's
or names supplied must be present within the \code{lib$phases$phase_id} or
\code{lib$phases$phase_name} columns.}

\item{mode}{denotes whether the phase ID's or names defined in the \code{refs} argument are
retained (\code{"keep"}) or removed (\code{"remove"}).}

\item{...}{other arguments}
}
\value{
a \code{powdRlib} object.
}
\description{
\code{subset.powdRlib} is designed to provide an easy way of
subsetting a \code{powdRlib} object by defining the phase ID's
that the user wishes to either keep or remove.
}
\examples{
#Load the minerals library
data(minerals)

minerals_keep <- subset(minerals,
                        refs = c("QUA.1", "QUA.2"),
                        mode = "keep")

minerals_remove <- subset(minerals,
                          refs = c("QUA.1", "QUA.2"),
                          mode = "remove")
}
