% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate.multiXY}
\alias{interpolate.multiXY}
\title{Interpolate a multiXY object onto a given 2theta scale.}
\usage{
\method{interpolate}{multiXY}(x, new_tth, ...)
}
\arguments{
\item{x}{a \code{multiXY} object.}

\item{new_tth}{a numeric vector of the new 2theta scale.}

\item{...}{other arguments}
}
\value{
a \code{multiXY} object.
}
\description{
\code{interpolate} takes a \code{multiXY} object, which may contain
XY data frames with varying 2theta scales, and interpolates all
data frames onto the same scale using cubic splines.
}
\examples{
data(rockjock_mixtures)

#Define a new 2theta scale:
tth <- seq(10, 60, 0.04)

#interpolate data onto new scale
i1 <- interpolate(rockjock_mixtures, new_tth = tth)
}
