% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerRegAcc.R
\name{getAccRegion}
\alias{getAccRegion}
\alias{getAccRegion_data}
\title{Functions for computing the region of acceptance}
\usage{
getAccRegion(
  tss,
  null_model = "yule",
  n,
  distribs = "sampled",
  sample_size = 1000L,
  test_type = "two-tailed",
  sig_lvl = 0.05
)

getAccRegion_data(tss_data, test_type = "two-tailed", sig_lvl = 0.05)
}
\arguments{
\item{tss}{Vector containing the names (as character) of the tree shape
statistics that should be compared. You may either use the short names
provided in \code{tssInfo} to use the already included TSS, or use the
name of a list object containing similar information as the entries in
\code{tssInfo}. Example:\cr
Use \code{"new_tss"} as the name for the list object
\code{new_tss} containing at least the function
\code{new_tss$func = function(tree){...}},
and optionally also the information \code{new_tss$short},
\code{new_tss$simple}, \code{new_tss$name}, \code{new_tss$type},
\code{new_tss$only_binary}, and \code{new_tss$safe_n}.}

\item{null_model}{The null model that is to be used to determine the power
of the tree shape statistics. In general, it must be a function that
produces rooted binary trees in \code{phylo} format. \cr
If the respective model is included in this
package, then specify the model and its parameters by using a character
or list. Available are all options listed under parameter \code{tm} in
the documentation of function \code{genTrees} (type \code{?genTrees}).\cr
If you want to include your own tree model, then use the
name of a list object containing the function (with the two input parameters
\code{n} and \code{Ntrees}). Example: \cr
Use \code{"new_tm"} for the list object
\code{new_tm <- list(func = function(n, Ntrees){...})}.}

\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0.}

\item{distribs}{Determines how the distributions and quantiles are computed.
Available are: \cr
\itemize{
\item "sampled" (default): \code{sample_size} many trees are sample under the
respective models to determine the quantiles for the null model and how many
trees under the alternative models lie outside.
}}

\item{sample_size}{Sample size (integer >=10) if distributions are sampled
(default= 1000L).}

\item{test_type}{Determines the method. Available are: \cr
\itemize{
\item "two-tailed" (default)
}}

\item{sig_lvl}{Level of significance (default=0.05, must be >0 and <1).}

\item{tss_data}{Numeric matrix of TSS values (one row per TSS). The row names
are used as names for the TSS.}
}
\value{
\code{getAccRegion} Numeric matrix (one row per TSS) with two
columns for the interval limits of the acceptance region.

\code{getAccRegion_data} Numeric matrix (one row per TSS) with two
columns for the interval limits of the acceptance region.
}
\description{
\code{getAccRegion} - Computes the region of acceptance based on quantiles
for a specified level of significance and method. The critical region is
everything strictly outside this interval, i.e., the interval limits still
belong to the acceptance region.

\code{getAccRegion_data} - Computes the region of acceptance for the
given TSS values based on quantiles for a specified level of significance and
method. The critical region is everything strictly outside this interval,
i.e., the interval limits still belong to the acceptance region.
}
\examples{
getAccRegion(tss = c("Sackin", "Colless", "B1I"), n = 8L, sample_size = 100L)
getAccRegion_data(getTSSdata(tss = c("Colless", "Sackin"), n = 8L,
                             Ntrees = 20L, tm = "yule"))
}
\author{
Sophie Kersting
}
