% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_diag.R
\name{pp_diag}
\alias{pp_diag}
\alias{pp_diag.default}
\alias{pp_diag.hp}
\alias{pp_diag.mmhp}
\alias{pp_diag.mmpp}
\alias{pp_diag.hpp}
\title{Summarise diagnostics for point process models}
\usage{
pp_diag(object, events)

\method{pp_diag}{default}(object, events)

\method{pp_diag}{hp}(object, events)

\method{pp_diag}{mmhp}(object, events)

\method{pp_diag}{mmpp}(object, events)

\method{pp_diag}{hpp}(object, events)
}
\arguments{
\item{object}{a point process model}

\item{events}{event times}
}
\value{
Display QQ-plot and KS plot, along with printing Pearson
 and raw residuals.
}
\description{
Generate diagnostic tools for different point process models, 
including quantile-quantile plot, ks plot, 
raw residual and pearson residual.
}
\examples{
hpp_obj <- pp_hpp(lambda = 1)
events <- pp_simulate(hpp_obj, end=50)
pp_diag(hpp_obj, events)
}
