% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiIND2016_r66}
\alias{ppiIND2016_r66}
\title{Poverty Probability Index (PPI) lookup table for India using r66 poverty
definitions}
\format{
A data frame with 8 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{tendulkar}}{National tendulkar}
\item{\code{tendulkar100}}{National tendulkar (100\%)}
\item{\code{tendulkar150}}{National tendulkar (150\%)}
\item{\code{tendulkar200}}{National tendulkar (200\%)}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp188}}{Below $1.88 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiIND2016_r66
}
\description{
Poverty Probability Index (PPI) lookup table for India using r66 poverty
definitions
}
\examples{
  # Access India PPI table
  ppiIND2016_r66

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiIND2016_r66[ppiIND2016_r66$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiIND2016_r66, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # tendulkar poverty definition
  ppiScore <- 50
  ppiIND2016_r66[ppiIND2016_r66$score == ppiScore, "tendulkar"]

}
\keyword{datasets}
