% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{generateDynppsbmConst}
\alias{generateDynppsbmConst}
\title{Data under dynppsbm with piecewise constant intensities}
\usage{
generateDynppsbmConst(intens, Time, n, prop.groups, directed = TRUE)
}
\arguments{
\item{intens}{Matrix with piecewise constant intensities \eqn{\alpha^{(q,l)}} (each row gives the constants of the piecewise constant intensity for a group pair \eqn{(q,l)})}

\item{Time}{Time}

\item{n}{Total number of nodes}

\item{prop.groups}{Vector of group proportions, should be of length \eqn{Q}}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case

If directed then intens should be of length \eqn{Q^2} and if undirected then length \eqn{Q*(Q+1)/2}}
}
\description{
Generate data under dynppsbm with piecewise constant intensities
}
\examples{
intens1 <- c(1,3,8)
intens2 <- c(2,3,6)

intens <- matrix(c(intens1,intens2,intens1,intens2),4,3)

Time <- 10
n <- 20
prop.groups <- c(0.2,0.3)
dynppsbm <- generateDynppsbmConst(intens,Time,n,prop.groups,directed=TRUE)

}
