\name{ppval}
\alias{mkpp}
\alias{ppval}
\title{
  Piecewise Polynomial Structures
}
\description{
  Make or evaluate a piecewise polynomial.
}
\usage{
mkpp(x, P)

ppval(pp, xx)
}
\arguments{
  \item{x}{increasing vector of real numbers.}
  \item{P}{matrix containing the coefficients of polynomials in each row.}
  \item{pp}{a piecewise polynomial structure, generated by \code{mkpp}.}
  \item{xx}{numerical vector}
}
\details{
  \code{pp<-mkpp(x,P)} builds a piecewise polynomial from its breaks
  \code{x} and coefficients \code{P}. \code{x} is a monotonically increasing
  vector of length \code{L+1}, and \code{P} is an \code{L-by-k} matrix where 
  each row contains the coefficients of the polynomial of order \code{k}, from 
  highest to lowest exponent, on the interval \code{[x[i],x[i+1])}.

  \code{ppval(pp,xx)} returns the values of the piecewise polynomial
  \code{pp} at the entries of the vector \code{xx}. The first and last
  polynomial will be extended to the left resp. right of the interval
  \code{[x[1],x[L+1])}.
}
\value{
  \code{mkpp} will return a piecewise polynomial structure, that is a list
  with components \code{breaks=x}, \code{pieces=P}, \code{order=k} and
  \code{dim=1} for scalar-valued functions.
}
\note{
  Matlab allows to generate vector-valued piecewise polynomials. This may be
  included in later versions.
}
\author{
  HwB  email: <hwborchers@googlemail.com>
}
\seealso{
  \code{\link{cubicspline}}
}
\examples{
##  Example: Linear interpolation of the sine function
xs <- linspace(0, pi, 10)
ys <- sin(xs)
P <- matrix(NA, nrow = 9, ncol = 2)
for (i in 1:9) {
    P[i, ] <- c((ys[i+1]-ys[i])/(xs[i+1]-xs[i]), ys[i])
}
ppsin <- mkpp(xs, P)

\dontrun{
plot(xs, ys); grid()
x100 <- linspace(0, pi, 100)
lines(x100, sin(x100), col="darkgray")
ypp <- ppval(ppsin, x100)
lines(x100, ypp, col="red")
}
}
\keyword{ fitting }
