% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.predint.R
\name{summary.predint}
\alias{summary.predint}
\title{Summarizing objects of class \code{predint}}
\usage{
\method{summary}{predint}(object, ...)
}
\arguments{
\item{object}{object of class \code{predint}}

\item{...}{further arguments passed over to \code{base::cbind()} and \code{base::data.frame()}}
}
\value{
A \code{data.frame} containing the actual data (if provided via \code{newdat}),
the prediction interval (or limit), the expected value for the future observation,
the bootstrap calibrated coefficient(s), the prediction standard error and
a statement about the coverage for each future observation, if new observations
were provided via \code{newdat}.
}
\description{
This function gives a summary about the prediction intervals (and limits)
computed with \pkg{predint}.
}
\examples{

# Fitting a random effects model based on c2_dat1
\donttest{fit <- lme4::lmer(y_ijk~(1|a)+(1|b)+(1|a:b), c2_dat1)}


# Prediction interval using c2_dat2 as future data
\donttest{pred_int <- lmer_pi_futmat(model=fit, newdat=c2_dat2, alternative="both", nboot=100)}
\donttest{summary(pred_int)}

#----------------------------------------------------------------------------

# Please note that nboot was set to 100 in order to decrease computing time
# of the example. For a valid analysis set nboot=10000.

}
