% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-size.r
\name{treatment_power}
\alias{treatment_power}
\title{Treatment Effect Power Calculation}
\usage{
treatment_power(N, sigma2, delta_tau, alpha = 0.05, theta = 0.5, xi = 1,
  nstrata = 1)
}
\arguments{
\item{N}{overall study sample size.}

\item{sigma2}{variance estimate. Should be positive numeric values. If study
is stratified, should be vector of within-stratum variances 
with length equal to the number of strata in the study.}

\item{delta_tau}{overall study treatment effect.}

\item{alpha}{desired type I error rate..}

\item{theta}{proportion of patients assigned to choice arm in the initial
randomization. Should be numeric value between
0 and 1 (default=0.5).}

\item{xi}{a numeric vector of the proportion of patients in each stratum. 
Length of vector should equal the number of strata in the study and 
sum of vector should be 1. All vector elements should be numeric 
values between 0 and 1. Default is 1 (i.e. unstratified design).}

\item{nstrata}{number of strata. Default is 1 (i.e. unstratified design).}
}
\description{
Calculates the study power to detect the treatment effect given a particular 
sample size in a two-stage randomized clinical trial
}
\examples{
# Unstratified
treatment_power(N=300, sigma2=1, delta_tau=0.5)
# Stratified
treatment_power(N=300, sigma2=c(1,1), delta_tau=0.5, xi=c(0.5,0.5), nstrata=2)
}
\references{
Turner RM, et al. (2014). "Sample Size and Power When Designing
 a Randomized Trial for the Estimation of Treatment, Selection, and 
 Preference Effects." \emph{Medical Decision Making}, \strong{34}:711-719.
(\href{https://www.ncbi.nlm.nih.gov/pubmed/24695962}{PubMed})

Cameron B, Esserman D (2016). "Sample Size and Power for a 
Stratified Doubly Randomized Preference Design." \emph{Stat Methods Med Res}. 
(\href{https://www.ncbi.nlm.nih.gov/pubmed/27872194}{PubMed})
}
