% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-size.r
\name{overall_power}
\alias{overall_power}
\title{Power Calculation from Sample Size}
\usage{
overall_power(
  N,
  phi,
  sigma2,
  delta_pi,
  delta_nu,
  delta_tau,
  alpha = 0.05,
  theta = 0.5,
  xi = 1,
  nstrata = 1,
  k = 1
)
}
\arguments{
\item{N}{overall study sample size.}

\item{phi}{the proportion of patients preferring treatment 1. Should be
numeric value between 0 and 1. If study is stratified, should be
vector with length equal to the number of strata in the study.}

\item{sigma2}{variance estimate. Should be positive numeric values. If study
is stratified, should be vector of within-stratum variances 
with length equal to the number of strata in the study.}

\item{delta_pi}{overall study preference effect.}

\item{delta_nu}{overall study selection effect.}

\item{delta_tau}{overall study treatment effect.}

\item{alpha}{desired type I error rate.}

\item{theta}{proportion of patients assigned to choice arm in the initial
randomization. Should be numeric value between
0 and 1 (default=0.5).}

\item{xi}{a numeric vector of the proportion of patients in each stratum. 
Length of vector should equal the number of strata in the study and 
sum of vector should be 1. All vector elements should be numeric 
values between 0 and 1. Default is 1 (i.e. unstratified design).}

\item{nstrata}{number of strata. Default is 1 (i.e. unstratified design).}

\item{k}{the ratio of treatment A to treatment B in the random arm
(default 1).}
}
\description{
Calculates the study power to detect a set of effects given a particular 
sample size in a two-stage randomized clinical trial
}
\references{
Turner RM, et al. (2014). "Sample Size and Power When Designing
 a Randomized Trial for the Estimation of Treatment, Selection, and 
 Preference Effects." \emph{Medical Decision Making}, \strong{34}:711-719.
(\href{https://www.ncbi.nlm.nih.gov/pubmed/24695962}{PubMed})

Cameron B, Esserman D (2016). "Sample Size and Power for a 
Stratified Doubly Randomized Preference Design." \emph{Stat Methods Med Res}.
(\href{https://www.ncbi.nlm.nih.gov/pubmed/27872194}{PubMed})
}
\keyword{internal}
